"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NonTextFieldsBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _ = require("..");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NonTextFieldsBody = () => {
  const {
    nonTextResultFields
  } = (0, _kea.useValues)(_.ResultSettingsLogic);
  const {
    toggleRawForField
  } = (0, _kea.useActions)(_.ResultSettingsLogic);
  const resultSettingsArray = (0, _react.useMemo)(() => {
    return Object.entries(nonTextResultFields).sort(([aFieldName], [bFieldName]) => aFieldName > bFieldName ? 1 : -1);
  }, [nonTextResultFields]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, resultSettingsArray.map(([fieldName, fieldSettings]) => /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    key: fieldName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "data-test-subj": "ResultSettingFieldName"
  }, /*#__PURE__*/_react.default.createElement("code", null, fieldName)), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCellCheckbox, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.rawAriaLabel', {
      defaultMessage: 'Toggle raw field'
    }),
    "data-test-subj": "ResultSettingRawCheckBox",
    id: `${fieldName}-raw}`,
    checked: !!fieldSettings.raw,
    onChange: () => {
      toggleRawForField(fieldName);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    colSpan: 4,
    "aria-hidden": true
  }))));
};
exports.NonTextFieldsBody = NonTextFieldsBody;