"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BoostItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../components");
var _constants = require("../constants");
var _boost_item_content = require("./boost_item_content");
var _get_boost_summary = require("./get_boost_summary");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BoostItem = ({
  id,
  boost,
  index,
  name
}) => {
  const summary = (0, _react.useMemo)(() => (0, _get_boost_summary.getBoostSummary)(boost), [boost]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    className: "boosts__item",
    buttonContentClassName: "boosts__itemButton",
    initialIsOpen: !!boost.newBoost,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.BoostIcon, {
      type: boost.type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _constants.BOOST_TYPE_TO_DISPLAY_MAP[boost.type]), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
      sizes: ['xs', 's', 'm', 'l']
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textBreakAll"
    }, summary)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.ValueBadge, null, boost.factor))),
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_boost_item_content.BoostItemContent, {
    boost: boost,
    index: index,
    name: name
  }));
};
exports.BoostItem = BoostItem;