"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InputRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("./input_row.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InputRow = ({
  value,
  placeholder,
  autoFocus,
  onChange,
  onDelete,
  disableDelete,
  deleteLabel
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  className: "inputRow",
  alignItems: "center",
  responsive: false,
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  fullWidth: true,
  placeholder: placeholder,
  value: value,
  onChange: e => onChange(e.target.value),
  autoFocus: autoFocus
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
  iconType: "trash",
  color: "danger",
  onClick: onDelete,
  isDisabled: disableDelete,
  "aria-label": deleteLabel,
  title: deleteLabel,
  "data-test-subj": "deleteInputRowButton"
})));
exports.InputRow = InputRow;