"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesTableExpandedRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../constants");
var _shared_columns = require("./shared_columns");
require("./meta_engines_table_expanded_row.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesTableExpandedRow = ({
  sourceEngines,
  conflictingEngines
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "metaEnginesSourceEnginesTable"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs",
  className: "eui-textCenter"
}, /*#__PURE__*/_react.default.createElement("h3", null, _constants.SOURCE_ENGINES_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
  items: sourceEngines,
  columns: [{
    ..._shared_columns.NAME_COLUMN,
    mobileOptions: {
      ..._shared_columns.NAME_COLUMN.mobileOptions,
      // Note: the below props are valid props per https://elastic.github.io/eui/#/tabular-content/tables (Responsive tables), but EUI's types have a bug reporting it as an error
      // @ts-ignore
      enlarge: false
    }
  }, _shared_columns.CREATED_AT_COLUMN, _shared_columns.BLANK_COLUMN, _shared_columns.DOCUMENT_COUNT_COLUMN, {
    ..._shared_columns.FIELD_COUNT_COLUMN,
    render: (_, engineDetails) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, conflictingEngines.has(engineDetails.name) ? /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "warning"
    }, engineDetails.field_count) : engineDetails.field_count)
  }, _shared_columns.BLANK_COLUMN]
}));
exports.MetaEnginesTableExpandedRow = MetaEnginesTableExpandedRow;