"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewElasticsearchEngine = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine_creation_logic = require("./engine_creation_logic");
var _search_index_selectable = require("./search_index_selectable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewElasticsearchEngine = () => {
  const {
    aliasName,
    name,
    selectedIndex,
    selectedIndexFormatted
  } = (0, _kea.useValues)(_engine_creation_logic.EngineCreationLogic);
  const {
    setCreationStep,
    submitEngine
  } = (0, _kea.useActions)(_engine_creation_logic.EngineCreationLogic);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "entSearch__createEngineLayout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: [{
      onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.SelectStep),
      status: 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.searchEngineType.label', {
        defaultMessage: 'Search engine type'
      })
    }, {
      onClick: () => setCreationStep(_engine_creation_logic.EngineCreationSteps.ConfigureStep),
      status: 'complete',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.configuration.label', {
        defaultMessage: 'Configuration'
      })
    }, {
      onClick: () => {},
      status: 'current',
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.steps.review.label', {
        defaultMessage: 'Review'
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    "data-test-subj": "ElasticsearchEngineCreationForm",
    onSubmit: e => {
      e.preventDefault();
      submitEngine();
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.title.label', {
    defaultMessage: 'Review your search engine'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    textAlign: "center"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.description', {
    defaultMessage: 'Your App Search engine will be created with the following configuration.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.engineType.title', {
    defaultMessage: 'Engine Type'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.engineType.description', {
    defaultMessage: 'Elasticsearch index-based'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.aliasName.title', {
    defaultMessage: 'Alias Name'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, aliasName || '--'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.engineName.title', {
    defaultMessage: 'Engine Name'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, name)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.reviewForm.elasticsearchIndex.title', {
    defaultMessage: 'Elasticsearch Index'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, selectedIndex), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_search_index_selectable.IndexStatusDetails, {
    option: selectedIndexFormatted
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), aliasName.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "ElasticsearchEngineCreationFormAliasNameCallout",
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.configureElasticsearchEngine.callout.title', {
      defaultMessage: 'An alias will be created and used for this engine'
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "xpack.enterpriseSearch.appSearch.engineCreation.configureElasticsearchEngine.callout.body",
    default: `Enterprise Search will create an alias for you named
                  {aliasName} and use it as the source of the engine, {name}.`,
    values: {
      aliasName: /*#__PURE__*/_react.default.createElement("b", null, aliasName),
      name: /*#__PURE__*/_react.default.createElement("b", null, name)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "NewEngineBackButton",
    color: "primary",
    iconType: "arrowLeft",
    onClick: () => {
      setCreationStep(_engine_creation_logic.EngineCreationSteps.ConfigureStep);
    }
  }, _i18n.i18n.translate(
  // FIXME: this and the rest of the paths
  'xpack.enterpriseSearch.appSearch.engineCreation.form.editConfiguration.label', {
    defaultMessage: 'Edit configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    "data-test-subj": "NewEngineSubmitButton",
    iconType: "arrowRight",
    iconSide: "right",
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engineCreation.form.continue.label', {
    defaultMessage: 'Create search engine'
  })))))));
};
exports.ReviewElasticsearchEngine = ReviewElasticsearchEngine;