"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentsLogic = void 0;
var _kea = require("kea");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentsLogic = exports.DocumentsLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'documents_logic'],
  actions: () => ({
    openDocumentCreation: true,
    closeDocumentCreation: true
  }),
  reducers: () => ({
    isDocumentCreationOpen: [false, {
      openDocumentCreation: () => true,
      closeDocumentCreation: () => false
    }]
  })
});