"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Errors = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ = require("..");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Errors = () => {
  const {
    errors,
    warnings
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, errors.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: _constants.DOCUMENT_CREATION_ERRORS.TITLE
  }, errors.map((message, index) => /*#__PURE__*/_react.default.createElement("p", {
    key: index
  }, message))), warnings.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: _constants.DOCUMENT_CREATION_WARNINGS.TITLE
  }, warnings.map((message, index) => /*#__PURE__*/_react.default.createElement("p", {
    key: index
  }, message))));
};
exports.Errors = Errors;