"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutHeader = exports.FlyoutFooter = exports.FlyoutBody = exports.ElasticsearchIndex = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _ = require("..");
var _constants = require("../../../../shared/constants");
var _constants2 = require("../constants");
var _creation_response_components = require("../creation_response_components");
require("./paste_json_text.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ElasticsearchIndex = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlyoutHeader, null), /*#__PURE__*/_react.default.createElement(FlyoutBody, null), /*#__PURE__*/_react.default.createElement(FlyoutFooter, null));
exports.ElasticsearchIndex = ElasticsearchIndex;
const FlyoutHeader = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: _constants2.FLYOUT_ARIA_LABEL_ID
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.elasticsearchIndex.title', {
    defaultMessage: 'Connect an Elasticsearch index'
  }))));
};
exports.FlyoutHeader = FlyoutHeader;
const FlyoutBody = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_creation_response_components.Errors, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.appSearch.documentCreation.elasticsearchIndex.description",
    defaultMessage: "'You can now connect directly to an existing Elasticsearch index to make its data searchable and tunable through Enterprise Search Uls. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        target: "_blank",
        href: 'TODO'
      }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.elasticsearchIndex.link', {
        defaultMessage: 'Learn more about using an existing index'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), '{Form fields go here}');
};
exports.FlyoutBody = FlyoutBody;
const FlyoutFooter = () => {
  // TODO: replace these
  const {
    textInput,
    isUploading
  } = (0, _kea.useValues)(_.DocumentCreationLogic);
  // TODO: replace 'onSubmitJson'
  const {
    onSubmitJson,
    closeDocumentCreation
  } = (0, _kea.useActions)(_.DocumentCreationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeDocumentCreation
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onSubmitJson,
    isLoading: isUploading,
    isDisabled: !textInput
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.documentCreation.elasticsearchIndex.button', {
    defaultMessage: 'Connect to index'
  })))));
};
exports.FlyoutFooter = FlyoutFooter;