"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddResultFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _flash_messages = require("../../../../../shared/flash_messages");
var _search = require("../../../search");
var _constants = require("../../constants");
var _curation_logic = require("../curation_logic");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddResultFlyout = () => {
  const searchLogic = (0, _search.SearchLogic)({
    id: 'add-results-flyout'
  });
  const {
    searchQuery,
    searchResults,
    searchDataLoading
  } = (0, _kea.useValues)(searchLogic);
  const {
    closeFlyout
  } = (0, _kea.useActions)(_.AddResultLogic);
  const {
    search
  } = (0, _kea.useActions)(searchLogic);
  const {
    promotedIds,
    hiddenIds
  } = (0, _kea.useValues)(_curation_logic.CurationLogic);
  const {
    addPromotedId,
    removePromotedId,
    addHiddenId,
    removeHiddenId
  } = (0, _kea.useActions)(_curation_logic.CurationLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: closeFlyout,
    "aria-labelledby": "addResultFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "addResultFlyout"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addResult.title', {
    defaultMessage: 'Add result to curation'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _constants.RESULT_ACTIONS_DIRECTIONS))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_flash_messages.FlashMessages, null)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchQuery,
    onChange: e => search(e.target.value),
    isLoading: searchDataLoading,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addResult.searchPlaceholder', {
      defaultMessage: 'Search engine documents'
    }),
    fullWidth: true,
    autoFocus: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), searchResults.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, searchResults.map((result, index) => {
    const id = result.id.raw;
    const isPromoted = promotedIds.includes(id);
    const isHidden = hiddenIds.includes(id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index
    }, /*#__PURE__*/_react.default.createElement(_.CurationResult, {
      result: result,
      actions: [isHidden ? {
        ..._constants.SHOW_DOCUMENT_ACTION,
        onClick: () => removeHiddenId(id)
      } : {
        ..._constants.HIDE_DOCUMENT_ACTION,
        onClick: () => addHiddenId(id)
      }, isPromoted ? {
        ..._constants.DEMOTE_DOCUMENT_ACTION,
        onClick: () => removePromotedId(id)
      } : {
        ..._constants.PROMOTE_DOCUMENT_ACTION,
        onClick: () => addPromotedId(id)
      }]
    }));
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curations.addResult.searchEmptyDescription', {
      defaultMessage: 'No matching content found.'
    })
  }))));
};
exports.AddResultFlyout = AddResultFlyout;