"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutomatedCurationHistory = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _log_stream = require("../../../../shared/log_stream");
var _data_panel = require("../../data_panel");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AutomatedCurationHistory = ({
  query,
  engineName
}) => {
  const [endTimestamp, setEndTimestamp] = (0, _react.useState)(Date.now());
  const filters = [`appsearch.adaptive_relevance.query: ${query}`, 'event.kind: event', 'event.dataset: search-relevance-suggestions', `appsearch.adaptive_relevance.engine: ${engineName}`, 'event.action: curation_suggestion', 'appsearch.adaptive_relevance.suggestion.new_status: automated'];
  return /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    iconType: "tableDensityNormal",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      component: "h2"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.detail.historyTableTitle', {
      defaultMessage: 'Adaptive relevance changes'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "refresh",
      size: "xs",
      onClick: () => setEndTimestamp(Date.now())
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.apiLogs.newEventsButtonLabel', {
      defaultMessage: 'Refresh'
    })))),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.curation.detail.historyTableDescription', {
      defaultMessage: 'A detailed log of recent changes to curations powered by adaptive relevance.'
    }),
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_log_stream.EntSearchLogStream, {
    logView: {
      type: 'log-view-reference',
      logViewId: 'default'
    },
    hoursAgo: 720,
    endTimestamp: endTimestamp,
    query: filters.join(' and '),
    columns: [{
      type: 'timestamp'
    }, {
      type: 'message'
    }]
  }));
};
exports.AutomatedCurationHistory = AutomatedCurationHistory;