"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRITE_ONLY = exports.UPDATE_MESSAGE = exports.TOKEN_TYPE_INFO = exports.TOKEN_TYPE_DISPLAY_NAMES = exports.TOKEN_TYPE_DESCRIPTION = exports.SEARCH_DISPLAY = exports.READ_WRITE = exports.READ_ONLY = exports.FLYOUT_ARIA_LABEL_ID = exports.DELETE_MESSAGE = exports.CREDENTIALS_TITLE = exports.CREATE_MESSAGE = exports.ApiTokenTypes = exports.ALL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CREDENTIALS_TITLE = exports.CREDENTIALS_TITLE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.credentials.title', {
  defaultMessage: 'Credentials'
});
let ApiTokenTypes = exports.ApiTokenTypes = /*#__PURE__*/function (ApiTokenTypes) {
  ApiTokenTypes["Admin"] = "admin";
  ApiTokenTypes["Private"] = "private";
  ApiTokenTypes["Search"] = "search";
  return ApiTokenTypes;
}({});
const CREATE_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.created', {
  defaultMessage: "API key ''{name}'' was created",
  values: {
    name
  }
});
exports.CREATE_MESSAGE = CREATE_MESSAGE;
const UPDATE_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.update', {
  defaultMessage: "API key ''{name}'' was updated",
  values: {
    name
  }
});
exports.UPDATE_MESSAGE = UPDATE_MESSAGE;
const DELETE_MESSAGE = name => _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.deleted', {
  defaultMessage: "API key ''{name}'' was deleted",
  values: {
    name
  }
});
exports.DELETE_MESSAGE = DELETE_MESSAGE;
const SEARCH_DISPLAY = exports.SEARCH_DISPLAY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.permissions.display.search', {
  defaultMessage: 'search'
});
const ALL = exports.ALL = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.permissions.display.all', {
  defaultMessage: 'all'
});
const READ_WRITE = exports.READ_WRITE = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.permissions.display.readwrite', {
  defaultMessage: 'read/write'
});
const READ_ONLY = exports.READ_ONLY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.permissions.display.readonly', {
  defaultMessage: 'read-only'
});
const WRITE_ONLY = exports.WRITE_ONLY = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.permissions.display.writeonly', {
  defaultMessage: 'write-only'
});
const TOKEN_TYPE_DESCRIPTION = exports.TOKEN_TYPE_DESCRIPTION = {
  [ApiTokenTypes.Search]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.search.description', {
    defaultMessage: 'Public Search Keys are used for search endpoints only.'
  }),
  [ApiTokenTypes.Private]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.private.description', {
    defaultMessage: 'Private API Keys are used for read and/or write access on one or more Engines.'
  }),
  [ApiTokenTypes.Admin]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.admin.description', {
    defaultMessage: 'Private Admin Keys are used to interact with the Credentials API.'
  })
};
const TOKEN_TYPE_DISPLAY_NAMES = exports.TOKEN_TYPE_DISPLAY_NAMES = {
  [ApiTokenTypes.Search]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.search.name', {
    defaultMessage: 'Public Search Key'
  }),
  [ApiTokenTypes.Private]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.private.name', {
    defaultMessage: 'Private API Key'
  }),
  [ApiTokenTypes.Admin]: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.tokens.admin.name', {
    defaultMessage: 'Private Admin Key'
  })
};
const TOKEN_TYPE_INFO = exports.TOKEN_TYPE_INFO = [{
  value: ApiTokenTypes.Search,
  text: TOKEN_TYPE_DISPLAY_NAMES[ApiTokenTypes.Search]
}, {
  value: ApiTokenTypes.Private,
  text: TOKEN_TYPE_DISPLAY_NAMES[ApiTokenTypes.Private]
}, {
  value: ApiTokenTypes.Admin,
  text: TOKEN_TYPE_DISPLAY_NAMES[ApiTokenTypes.Admin]
}];
const FLYOUT_ARIA_LABEL_ID = exports.FLYOUT_ARIA_LABEL_ID = 'credentialsFlyoutTitle';