"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerSingleDomain = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _engine = require("../engine");
var _layout = require("../layout");
var _crawl_custom_settings_flyout = require("./components/crawl_custom_settings_flyout/crawl_custom_settings_flyout");
var _crawl_rules_table = require("./components/crawl_rules_table");
var _crawl_select_domains_modal = require("./components/crawl_select_domains_modal/crawl_select_domains_modal");
var _crawler_status_banner = require("./components/crawler_status_banner");
var _crawler_status_indicator = require("./components/crawler_status_indicator/crawler_status_indicator");
var _deduplication_panel = require("./components/deduplication_panel");
var _delete_domain_panel = require("./components/delete_domain_panel");
var _entry_points_table = require("./components/entry_points_table");
var _manage_crawls_popover = require("./components/manage_crawls_popover/manage_crawls_popover");
var _sitemaps_table = require("./components/sitemaps_table");
var _constants = require("./constants");
var _crawler_single_domain_logic = require("./crawler_single_domain_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerSingleDomain = () => {
  const {
    domainId
  } = (0, _reactRouterDom.useParams)();
  const {
    engineName
  } = _engine.EngineLogic.values;
  const {
    dataLoading,
    domain
  } = (0, _kea.useValues)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  const {
    fetchDomainData
  } = (0, _kea.useActions)(_crawler_single_domain_logic.CrawlerSingleDomainLogic);
  (0, _react.useEffect)(() => {
    fetchDomainData(domainId);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.CRAWLER_TITLE, (domain === null || domain === void 0 ? void 0 : domain.url) || '...']),
    pageHeader: dataLoading ? undefined : {
      pageTitle: domain.url,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_manage_crawls_popover.ManageCrawlsPopover, null), /*#__PURE__*/_react.default.createElement(_crawler_status_indicator.CrawlerStatusIndicator, null)]
    },
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_crawler_status_banner.CrawlerStatusBanner, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), domain && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_entry_points_table.EntryPointsTable, {
    domain: domain,
    engineName: engineName,
    items: domain.entryPoints
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_sitemaps_table.SitemapsTable, {
    domain: domain,
    engineName: engineName,
    items: domain.sitemaps
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_crawl_rules_table.CrawlRulesTable, {
    domainId: domainId,
    engineName: engineName,
    crawlRules: domain.crawlRules,
    defaultCrawlRule: domain.defaultCrawlRule
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_deduplication_panel.DeduplicationPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_delete_domain_panel.DeleteDomainPanel, null), /*#__PURE__*/_react.default.createElement(_crawl_select_domains_modal.CrawlSelectDomainsModal, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout.CrawlCustomSettingsFlyout, null));
};
exports.CrawlerSingleDomain = CrawlerSingleDomain;