"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageCrawlsPopover = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _automatic_crawl_scheduler = require("./automatic_crawl_scheduler");
var _manage_crawls_popover_logic = require("./manage_crawls_popover_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageCrawlsPopover = ({
  domain
}) => {
  const {
    closePopover,
    reApplyCrawlRules,
    togglePopover
  } = (0, _kea.useActions)(_manage_crawls_popover_logic.ManageCrawlsPopoverLogic);
  const {
    isOpen
  } = (0, _kea.useValues)(_manage_crawls_popover_logic.ManageCrawlsPopoverLogic);
  const panels = [{
    id: 0,
    items: [{
      name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.manageCrawlsPopover.reApplyCrawlRulesButtonLabel', {
        defaultMessage: 'Re-apply crawl rules'
      }),
      icon: 'refresh',
      onClick: () => reApplyCrawlRules(domain)
    }, {
      name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.manageCrawlsPopover.automaticCrawlingButtonLabel', {
        defaultMessage: 'Automatic crawling'
      }),
      icon: 'gear',
      panel: 1
    }]
  }, {
    id: 1,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.manageCrawlsPopover.automaticCrawlingTitle', {
      defaultMessage: 'Automatic crawling'
    }),
    width: 400,
    content: /*#__PURE__*/_react.default.createElement(_automatic_crawl_scheduler.AutomaticCrawlScheduler, null)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    closePopover: closePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: togglePopover,
      iconType: "arrowDown",
      iconSide: "right"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.manageCrawlsPopover.manageCrawlsButtonLabel', {
      defaultMessage: 'Manage crawls'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  }));
};
exports.ManageCrawlsPopover = ManageCrawlsPopover;