"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DomainsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../shared/constants");
var _kibana = require("../../../../shared/kibana");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _table_pagination = require("../../../../shared/table_pagination");
var _app_logic = require("../../../app_logic");
var _routes = require("../../../routes");
var _engine = require("../../engine");
var _crawler_domains_logic = require("../crawler_domains_logic");
var _utils = require("../utils");
var _custom_formatted_timestamp = require("./custom_formatted_timestamp");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DomainsTable = () => {
  const {
    domains,
    meta,
    dataLoading
  } = (0, _kea.useValues)(_crawler_domains_logic.CrawlerDomainsLogic);
  const {
    fetchCrawlerDomainsData,
    onPaginate,
    deleteDomain
  } = (0, _kea.useActions)(_crawler_domains_logic.CrawlerDomainsLogic);
  (0, _react.useEffect)(() => {
    fetchCrawlerDomainsData();
  }, [meta.page.current]);
  const {
    myRole: {
      canManageEngineCrawler
    }
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const columns = [{
    field: 'url',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.column.domainURL', {
      defaultMessage: 'Domain URL'
    }),
    render: (_, domain) => /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
      "data-test-subj": "CrawlerDomainURL",
      to: (0, _engine.generateEnginePath)(_routes.ENGINE_CRAWLER_DOMAIN_PATH, {
        domainId: domain.id
      })
    }, domain.url)
  }, {
    field: 'lastCrawl',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.column.lastActivity', {
      defaultMessage: 'Last activity'
    }),
    render: lastCrawl => lastCrawl ? /*#__PURE__*/_react.default.createElement(_custom_formatted_timestamp.CustomFormattedTimestamp, {
      timestamp: lastCrawl
    }) : ''
  }, {
    field: 'documentCount',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.column.documents', {
      defaultMessage: 'Documents'
    }),
    render: documentCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
      value: documentCount
    })
  }];
  const actionsColumn = {
    name: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.column.actions', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _constants.MANAGE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.action.manage.buttonLabel', {
        defaultMessage: 'Manage this domain'
      }),
      type: 'icon',
      icon: 'eye',
      onClick: domain => _kibana.KibanaLogic.values.navigateToUrl((0, _engine.generateEnginePath)(_routes.ENGINE_CRAWLER_DOMAIN_PATH, {
        domainId: domain.id
      }))
    }, {
      name: _constants.DELETE_BUTTON_LABEL,
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.domainsTable.action.delete.buttonLabel', {
        defaultMessage: 'Delete this domain'
      }),
      type: 'icon',
      icon: 'trash',
      color: 'danger',
      onClick: domain => {
        if (window.confirm((0, _utils.getDeleteDomainConfirmationMessage)(domain.url))) {
          deleteDomain(domain);
        }
      }
    }]
  };
  if (canManageEngineCrawler) {
    columns.push(actionsColumn);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: dataLoading,
    items: domains,
    columns: columns,
    pagination: {
      ...(0, _table_pagination.convertMetaToPagination)(meta),
      showPerPageOptions: false
    },
    onChange: (0, _table_pagination.handlePageChange)(onPaginate)
  });
};
exports.DomainsTable = DomainsTable;