"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlEventTypeBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _types = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlEventTypeBadge = ({
  event
}) => {
  if (event.stage === 'process') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.crawler.crawlTypeOptions.reAppliedCrawlRules', {
      defaultMessage: 'Re-applied crawl rules'
    }));
  }
  if (event.type === _types.CrawlType.Full) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, _types.readableCrawlTypes[_types.CrawlType.Full]);
  }
  if (event.type === _types.CrawlType.Partial) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow"
    }, _types.readableCrawlTypes[_types.CrawlType.Partial]);
  }
  return null;
};
exports.CrawlEventTypeBadge = CrawlEventTypeBadge;