"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStateIcon = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ValidationStateIcon = ({
  state
}) => {
  switch (state) {
    case 'valid':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "success",
        type: "check"
      });
    case 'warning':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "warning",
        type: "warning"
      });
    case 'invalid':
      return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        color: "danger",
        type: "cross"
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
};
exports.ValidationStateIcon = ValidationStateIcon;