"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppSearchGateLogic = void 0;
var _kea = require("kea");
var _app_search_gate_api_logic = require("./app_search_gate_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AppSearchGateLogic = exports.AppSearchGateLogic = (0, _kea.kea)({
  actions: {
    formSubmitRequest: true,
    setAdditionalFeedback: additionalFeedback => ({
      additionalFeedback
    }),
    setFeature: feature => ({
      feature
    }),
    setFeaturesOther: featuresOther => ({
      featuresOther
    }),
    setParticipateInUXLabs: participateInUXLabs => ({
      participateInUXLabs
    })
  },
  connect: {
    actions: [_app_search_gate_api_logic.UpdateAppSearchGatedFormDataApiLogic, ['makeRequest as submitGatedFormDataRequest', 'apiSuccess as submitGatedFormSuccess']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    formSubmitRequest: () => {
      if (values.feature) {
        actions.submitGatedFormDataRequest({
          additionalFeedback: values !== null && values !== void 0 && values.additionalFeedback ? values === null || values === void 0 ? void 0 : values.additionalFeedback : null,
          feature: values.feature,
          featuresOther: values !== null && values !== void 0 && values.featuresOther ? values === null || values === void 0 ? void 0 : values.featuresOther : null,
          participateInUXLabs: values === null || values === void 0 ? void 0 : values.participateInUXLabs
        });
      }
    },
    submitGatedFormSuccess: () => {
      window.location.reload();
    }
  }),
  path: ['enterprise_search', 'app_search', 'gate_form'],
  reducers: ({}) => ({
    additionalFeedback: [null, {
      setAdditionalFeedback: (_, {
        additionalFeedback
      }) => additionalFeedback !== null && additionalFeedback !== void 0 ? additionalFeedback : null
    }],
    feature: ['', {
      setFeature: (_, {
        feature
      }) => feature !== null && feature !== void 0 ? feature : ''
    }],
    featuresOther: [null, {
      setFeaturesOther: (_, {
        featuresOther
      }) => featuresOther !== null && featuresOther !== void 0 ? featuresOther : null
    }],
    participateInUXLabs: [null, {
      setParticipateInUXLabs: (_, {
        participateInUXLabs
      }) => participateInUXLabs !== null && participateInUXLabs !== void 0 ? participateInUXLabs : null
    }]
  })
});