"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionExplorerCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _kibana = require("../../../../shared/kibana");
var _use_discover_link = require("../use_discover_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnalyticsCollectionExplorerCallout = () => {
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const discoverLink = (0, _use_discover_link.useDiscoverLink)();
  return discoverLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collectionsView.explorer.callout.title', {
      defaultMessage: 'Need a deeper analysis?'
    }),
    iconType: "inspect"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.explorer.callout.description",
    defaultMessage: "Review your event logs in Discover to get more insights about your application metrics."
  })), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    href: discoverLink,
    "data-telemetry-id": "entSearch-analytics-explorer-callout-exploreLink"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.analytics.collectionsView.explorer.callout.button",
    defaultMessage: "Explore"
  })))) : null;
};
exports.AnalyticsCollectionExplorerCallout = AnalyticsCollectionExplorerCallout;