"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MeasurePerformanceSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _react_router_helpers = require("../../../shared/react_router_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const steps = [{
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step1.title', {
    defaultMessage: 'Create a collection'
  }),
  children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step1.description",
    defaultMessage: "Visit {behavioralAnalytics} and create your first collection.",
    values: {
      behavioralAnalytics: /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        "data-telemetry-id": "entSearch-aiSearch-measurePerformance-behavioralAnalyticsLink",
        to: (0, _reactRouterDom.generatePath)(_constants.ANALYTICS_PLUGIN.URL),
        shouldNotCreateHref: true
      }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step1.behavioralAnalyticsLinkText', {
        defaultMessage: 'Behavioral Analytics'
      }))
    }
  }),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step2.title', {
    defaultMessage: 'Integrate the analytics tracker'
  }),
  children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step2.description",
    defaultMessage: "After creating a collection, follow the directions on how to integrate our tracker into your application or website."
  }),
  status: 'incomplete'
}, {
  title: _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step3.title', {
    defaultMessage: 'Review your dashboard'
  }),
  children: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.aiSearch.measurePerformanceSection.step3.description",
    defaultMessage: "Our dashboards and tools help you visualize your end-user behavior and measure the performance of your search applications."
  }),
  status: 'incomplete'
}];
const MeasurePerformanceSection = () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 4
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "s",
  justifyContent: "flexStart"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.measurePerformanceSection.title",
  defaultMessage: "Measure your performance"
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.enterpriseSearch.aiSearch.measurePerformanceSection.description",
  defaultMessage: "Use {behavioralAnalytics} dashboards and tools to visualize user behavior and measure the impact of your changes.",
  values: {
    behavioralAnalytics: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearch-aiSearch-measurePerformance-behavioralAnalyticsDocsLink",
      target: "_blank",
      href: _doc_links.docLinks.behavioralAnalytics,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.aiSearch.measurePerformanceSection.behavioralAnalyticsLinkText', {
      defaultMessage: 'Behavioral Analytics'
    }))
  }
})))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 6
}, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  hasBorder: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
  steps: steps,
  titleSize: "xs"
}))));
exports.MeasurePerformanceSection = MeasurePerformanceSection;