"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createScheduleExecutionSummary = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createScheduleExecutionSummary = rule => {
  var _ref, _executionStatus$erro, _executionStatus$erro2, _executionStatus$warn;
  const {
    executionStatus
  } = rule;
  if (executionStatus.status === 'pending') {
    return undefined;
  }
  return {
    date: executionStatus.lastExecutionDate.toISOString(),
    status: executionStatus.status,
    duration: executionStatus.lastDuration,
    message: (_ref = (_executionStatus$erro = (_executionStatus$erro2 = executionStatus.error) === null || _executionStatus$erro2 === void 0 ? void 0 : _executionStatus$erro2.message) !== null && _executionStatus$erro !== void 0 ? _executionStatus$erro : (_executionStatus$warn = executionStatus.warning) === null || _executionStatus$warn === void 0 ? void 0 : _executionStatus$warn.message) !== null && _ref !== void 0 ? _ref : ''
  };
};
exports.createScheduleExecutionSummary = createScheduleExecutionSummary;