"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findAlertSummaryRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _find_alert_summary_route = require("@kbn/elastic-assistant-common/impl/schemas/alert_summary/find_alert_summary_route.gen");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _lodash = _interopRequireDefault(require("lodash"));
var _prompt = require("../../lib/prompt");
var _utils = require("../utils");
var _helpers = require("../../ai_assistant_data_clients/alert_summary/helpers");
var _helpers2 = require("../helpers");
var _local_prompt_object = require("../../lib/prompt/local_prompt_object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findAlertSummaryRoute = (router, logger) => {
  router.versioned.get({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_ALERT_SUMMARY_URL_FIND,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {
      request: {
        query: (0, _common.buildRouteValidationWithZod)(_find_alert_summary_route.FindAlertSummaryRequestQuery)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    try {
      var _query$fields;
      const {
        query
      } = request;
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = await (0, _helpers2.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const dataClient = await ctx.elasticAssistant.getAlertSummaryDataClient();
      const actions = ctx.elasticAssistant.actions;
      const actionsClient = await actions.getActionsClientWithRequest(request);
      const savedObjectsClient = ctx.elasticAssistant.savedObjectsClient;
      const result = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.findDocuments({
        perPage: query.per_page,
        page: query.page,
        sortField: query.sort_field,
        sortOrder: query.sort_order,
        ...(query.filter ? {
          filter: decodeURIComponent(query.filter)
        } : {}),
        fields: (_query$fields = query.fields) === null || _query$fields === void 0 ? void 0 : _query$fields.map(f => _lodash.default.snakeCase(f))
      }));
      const prompt = await (0, _prompt.getPrompt)({
        actionsClient,
        connectorId: query.connector_id,
        promptId: _prompt.promptDictionary.alertSummary,
        promptGroupId: _local_prompt_object.promptGroupId.aiForSoc,
        savedObjectsClient
      });
      if (result) {
        return response.ok({
          body: {
            perPage: result.perPage,
            page: result.page,
            total: result.total,
            data: (0, _helpers.transformESSearchToAlertSummary)(result.data),
            prompt
          }
        });
      }
      return response.ok({
        body: {
          perPage: query.per_page,
          page: query.page,
          data: [],
          total: 0,
          prompt
        }
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.findAlertSummaryRoute = findAlertSummaryRoute;