"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDefaultAssistantGraph = exports.DEFAULT_ASSISTANT_GRAPH_ID = void 0;
var _langgraph = require("@langchain/langgraph");
var _step_router = require("./nodes/step_router");
var _model_input = require("./nodes/model_input");
var _run_agent = require("./nodes/run_agent");
var _execute_tools = require("./nodes/execute_tools");
var _get_persisted_conversation = require("./nodes/get_persisted_conversation");
var _persist_conversation_changes = require("./nodes/persist_conversation_changes");
var _respond = require("./nodes/respond");
var _constants = require("./constants");
var _state = require("./state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_ASSISTANT_GRAPH_ID = exports.DEFAULT_ASSISTANT_GRAPH_ID = 'Default Security Assistant Graph';
const getDefaultAssistantGraph = ({
  actionsClient,
  agentRunnable,
  contentReferencesStore,
  dataClients,
  createLlmInstance,
  logger,
  savedObjectsClient,
  // some chat models (bedrock) require a signal to be passed on agent invoke rather than the signal passed to the chat model
  signal,
  telemetryParams,
  telemetry,
  tools,
  replacements,
  getFormattedTime
}) => {
  try {
    // Default node parameters
    const nodeParams = {
      actionsClient,
      logger,
      savedObjectsClient,
      contentReferencesStore
    };
    const stateAnnotation = (0, _state.getStateAnnotation)({
      getFormattedTime
    });

    // Put together a new graph using default state from above
    const graph = new _langgraph.StateGraph(stateAnnotation).addNode(_constants.NodeType.GET_PERSISTED_CONVERSATION, state => (0, _get_persisted_conversation.getPersistedConversation)({
      ...nodeParams,
      state,
      conversationsDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.conversationsDataClient
    })).addNode(_constants.NodeType.PERSIST_CONVERSATION_CHANGES, state => (0, _persist_conversation_changes.persistConversationChanges)({
      ...nodeParams,
      state,
      conversationsDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.conversationsDataClient,
      replacements
    })).addNode(_constants.NodeType.AGENT, state => (0, _run_agent.runAgent)({
      ...nodeParams,
      config: {
        signal
      },
      state,
      agentRunnable,
      kbDataClient: dataClients === null || dataClients === void 0 ? void 0 : dataClients.kbDataClient
    })).addNode(_constants.NodeType.TOOLS, state => (0, _execute_tools.executeTools)({
      ...nodeParams,
      config: {
        signal
      },
      state,
      tools,
      telemetryParams,
      telemetry
    })).addNode(_constants.NodeType.RESPOND, async state => {
      const model = await createLlmInstance();
      return (0, _respond.respond)({
        ...nodeParams,
        config: {
          signal
        },
        state,
        model
      });
    }).addEdge(_constants.NodeType.GET_PERSISTED_CONVERSATION, _constants.NodeType.PERSIST_CONVERSATION_CHANGES).addEdge(_constants.NodeType.PERSIST_CONVERSATION_CHANGES, _constants.NodeType.AGENT).addNode(_constants.NodeType.MODEL_INPUT, state => (0, _model_input.modelInput)({
      ...nodeParams,
      state
    })).addEdge(_langgraph.START, _constants.NodeType.MODEL_INPUT).addEdge(_constants.NodeType.RESPOND, _langgraph.END).addEdge(_constants.NodeType.TOOLS, _constants.NodeType.AGENT).addConditionalEdges(_constants.NodeType.MODEL_INPUT, _step_router.stepRouter, {
      [_constants.NodeType.GET_PERSISTED_CONVERSATION]: _constants.NodeType.GET_PERSISTED_CONVERSATION,
      [_constants.NodeType.AGENT]: _constants.NodeType.AGENT
    }).addConditionalEdges(_constants.NodeType.AGENT, _step_router.stepRouter, {
      [_constants.NodeType.RESPOND]: _constants.NodeType.RESPOND,
      [_constants.NodeType.TOOLS]: _constants.NodeType.TOOLS,
      [_constants.NodeType.END]: _langgraph.END
    });
    return graph.compile();
  } catch (e) {
    throw new Error(`Unable to compile DefaultAssistantGraph\n${e}`);
  }
};
exports.getDefaultAssistantGraph = getDefaultAssistantGraph;