"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockOpenAndAcknowledgedAlertsQueryResults = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mockOpenAndAcknowledgedAlertsQueryResults = exports.mockOpenAndAcknowledgedAlertsQueryResults = {
  took: 13,
  timed_out: false,
  _shards: {
    total: 1,
    successful: 1,
    skipped: 0,
    failed: 0
  },
  hits: {
    total: {
      value: 31,
      relation: 'eq'
    },
    max_score: null,
    hits: [{
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'b6e883c29b32571aaa667fa13e65bbb4f95172a2b84bdfb85d6f16c72b2d2560',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/Users/james/unix1'],
        'process.hash.md5': ['85caafe3d324e3287b85348fa2fae492'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/Users/james/unix1 /Users/james/library/Keychains/login.keychain-db TempTemp1234!!'],
        'process.parent.name': ['unix1'],
        'user.name': ['james'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'process.code_signature.signing_id': ['nans-55554944e5f232edcf023cf68e8e5dac81584f78'],
        'process.pid': [1227],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.72442],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/Users/james/unix1'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': [''],
        'process.parent.executable': ['/Users/james/unix1'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['unix1'],
        'process.args': ['/Users/james/unix1', '/Users/james/library/Keychains/login.keychain-db', 'TempTemp1234!!'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [3],
        'process.name': ['unix1'],
        'process.parent.args': ['/Users/james/unix1', '/Users/james/library/Keychains/login.keychain-db', 'TempTemp1234!!'],
        '@timestamp': ['2024-05-07T12:48:45.032Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['/Users/james/unix1 /Users/james/library/Keychains/login.keychain-db TempTemp1234!!'],
        'host.risk.calculated_level': ['High'],
        _id: ['b6e883c29b32571aaa667fa13e65bbb4f95172a2b84bdfb85d6f16c72b2d2560'],
        'process.hash.sha1': ['4ca549355736e4af6434efc4ec9a044ceb2ae3c3'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:39.368Z']
      },
      sort: [99, 1715086125032]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '0215a6c5cc9499dd0290cd69a4947efb87d3ddd8b6385a766d122c2475be7367',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/Users/james/unix1'],
        'process.hash.md5': ['e62bdd3eaf2be436fca2e67b7eede603'],
        'event.category': ['malware', 'intrusion_detection', 'file'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.parent.name': ['My Go Application.app'],
        'user.name': ['james'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'process.code_signature.signing_id': ['a.out'],
        'process.pid': [1220],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.72442],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': [''],
        'process.parent.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['unix1'],
        'process.args': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['My Go Application.app'],
        'process.parent.args': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        '@timestamp': ['2024-05-07T12:48:45.030Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'host.risk.calculated_level': ['High'],
        _id: ['0215a6c5cc9499dd0290cd69a4947efb87d3ddd8b6385a766d122c2475be7367'],
        'process.hash.sha1': ['58a3bddbc7c45193ecbefa22ad0496b60a29dff2'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:38.061Z']
      },
      sort: [99, 1715086125030]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '600eb9eca925f4c5b544b4e9d3cf95d83b7829f8f74c5bd746369cb4c2968b9a',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/Users/james/unix1'],
        'process.hash.md5': ['85caafe3d324e3287b85348fa2fae492'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.parent.name': ['My Go Application.app'],
        'user.name': ['james'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'process.code_signature.signing_id': ['nans-55554944e5f232edcf023cf68e8e5dac81584f78'],
        'process.pid': [1220],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.72442],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/Users/james/unix1'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': [''],
        'process.parent.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['unix1'],
        'process.args': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['unix1'],
        'process.parent.args': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        '@timestamp': ['2024-05-07T12:48:45.029Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'host.risk.calculated_level': ['High'],
        _id: ['600eb9eca925f4c5b544b4e9d3cf95d83b7829f8f74c5bd746369cb4c2968b9a'],
        'process.hash.sha1': ['4ca549355736e4af6434efc4ec9a044ceb2ae3c3'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:37.881Z']
      },
      sort: [99, 1715086125029]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'e1f4a4ed70190eb4bd256c813029a6a9101575887cdbfa226ac330fbd3063f0c',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/Users/james/unix1'],
        'process.hash.md5': ['3f19892ab44eb9bc7bc03f438944301e'],
        'event.category': ['malware', 'intrusion_detection', 'file'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.parent.name': ['My Go Application.app'],
        'user.name': ['james'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['f80234ff6fed2c62d23f37443f2412fbe806711b6add2ac126e03e282082c8f5'],
        'process.code_signature.signing_id': ['com.apple.chmod'],
        'process.pid': [1219],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Software Signing'],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['0b18d6880dc9670ab2b955914598c96fc3d0097dc40ea61157b8c79e75edf231'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.72442],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/bin/chmod'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'process.parent.code_signature.subject_name': [''],
        'process.parent.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['unix1'],
        'process.args': ['chmod', '777', '/Users/james/unix1'],
        'process.code_signature.status': ['No error.'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['chmod'],
        'process.parent.args': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        '@timestamp': ['2024-05-07T12:48:45.028Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['chmod 777 /Users/james/unix1'],
        'host.risk.calculated_level': ['High'],
        _id: ['e1f4a4ed70190eb4bd256c813029a6a9101575887cdbfa226ac330fbd3063f0c'],
        'process.hash.sha1': ['217490d4f51717aa3b301abec96be08602370d2d'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:37.869Z']
      },
      sort: [99, 1715086125028]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '2a7a4809ca625dfe22ccd35fbef7a7ba8ed07f109e5cbd17250755cfb0bc615f',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['643dddff1a57cbf70594854b44eb1a1d'],
        'event.category': ['malware', 'intrusion_detection'],
        'host.risk.calculated_score_norm': [73.02488],
        'rule.reference': ['https://github.com/EmpireProject/EmPyre/blob/master/lib/modules/collection/osx/prompt.py', 'https://ss64.com/osx/osascript.html'],
        'process.parent.name': ['My Go Application.app'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['bab17feba710b469e5d96820f0cb7ed511d983e5817f374ec3cb46462ac5b794'],
        'process.pid': [1206],
        'process.code_signature.exists': [true],
        'process.code_signature.subject_name': ['Software Signing'],
        'host.os.version': ['13.4'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.72442],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malicious Behavior Detection Alert: Potential Credentials Phishing via OSASCRIPT'],
        'host.name': ['SRVMAC08'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'group.name': ['staff'],
        'kibana.alert.workflow_status': ['open'],
        'rule.name': ['Potential Credentials Phishing via OSASCRIPT'],
        'threat.tactic.id': ['TA0006'],
        'threat.tactic.name': ['Credential Access'],
        'threat.technique.id': ['T1056'],
        'process.parent.args_count': [0],
        'threat.technique.subtechnique.reference': ['https://attack.mitre.org/techniques/T1056/002/'],
        'process.name': ['osascript'],
        'threat.technique.subtechnique.name': ['GUI Input Capture'],
        'process.parent.code_signature.trusted': [false],
        _id: ['2a7a4809ca625dfe22ccd35fbef7a7ba8ed07f109e5cbd17250755cfb0bc615f'],
        'threat.technique.name': ['Input Capture'],
        'group.id': ['20'],
        'threat.tactic.reference': ['https://attack.mitre.org/tactics/TA0006/'],
        'user.name': ['james'],
        'threat.framework': ['MITRE ATT&CK'],
        'process.code_signature.signing_id': ['com.apple.osascript'],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        'event.module': ['endpoint'],
        'process.executable': ['/usr/bin/osascript'],
        'process.parent.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.args': ['osascript', '-e', 'display dialog "MacOS wants to access System Preferences\n\t\t\nPlease enter your password." with title "System Preferences" with icon file "System:Library:CoreServices:CoreTypes.bundle:Contents:Resources:ToolbarAdvanced.icns" default answer "" giving up after 30 with hidden answer ¬'],
        'process.code_signature.status': ['No error.'],
        message: ['Malicious Behavior Detection Alert: Potential Credentials Phishing via OSASCRIPT'],
        '@timestamp': ['2024-05-07T12:48:45.027Z'],
        'threat.technique.subtechnique.id': ['T1056.002'],
        'threat.technique.reference': ['https://attack.mitre.org/techniques/T1056/'],
        'process.command_line': ['osascript -e display dialog "MacOS wants to access System Preferences\n\t\t\nPlease enter your password." with title "System Preferences" with icon file "System:Library:CoreServices:CoreTypes.bundle:Contents:Resources:ToolbarAdvanced.icns" default answer "" giving up after 30 with hidden answer ¬'],
        'host.risk.calculated_level': ['High'],
        'process.hash.sha1': ['0568baae15c752208ae56d8f9c737976d6de2e3a'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:09.909Z']
      },
      sort: [99, 1715086125027]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '2a9f7602de8656d30dda0ddcf79e78037ac2929780e13d5b2047b3bedc40bb69',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.hash.md5': ['e62bdd3eaf2be436fca2e67b7eede603'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/sbin/launchd'],
        'process.parent.name': ['launchd'],
        'user.name': ['root'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'process.code_signature.signing_id': ['a.out'],
        'process.pid': [1200],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['No error.'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.491455],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/6D63F08A-011C-4511-8556-EAEF9AFD6340/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': ['Software Signing'],
        'process.parent.executable': ['/sbin/launchd'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['My Go Application.app'],
        'process.args': ['xpcproxy', 'application.Appify by Machine Box.My Go Application.20.23'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['My Go Application.app'],
        'process.parent.args': ['/sbin/launchd'],
        '@timestamp': ['2024-05-07T12:48:45.023Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['xpcproxy application.Appify by Machine Box.My Go Application.20.23'],
        'host.risk.calculated_level': ['High'],
        _id: ['2a9f7602de8656d30dda0ddcf79e78037ac2929780e13d5b2047b3bedc40bb69'],
        'process.hash.sha1': ['58a3bddbc7c45193ecbefa22ad0496b60a29dff2'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:28:06.888Z']
      },
      sort: [99, 1715086125023]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '4615c3a90e8057ae5cc9b358bbbf4298e346277a2f068dda052b0b43ef6d5bbd',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/3C4D44B9-4838-4613-BACC-BD00A9CE4025/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.hash.md5': ['e62bdd3eaf2be436fca2e67b7eede603'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/sbin/launchd'],
        'process.parent.name': ['launchd'],
        'user.name': ['root'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'process.code_signature.signing_id': ['a.out'],
        'process.pid': [1169],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['No error.'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.491455],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/3C4D44B9-4838-4613-BACC-BD00A9CE4025/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': ['Software Signing'],
        'process.parent.executable': ['/sbin/launchd'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['My Go Application.app'],
        'process.args': ['xpcproxy', 'application.Appify by Machine Box.My Go Application.20.23'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['My Go Application.app'],
        'process.parent.args': ['/sbin/launchd'],
        '@timestamp': ['2024-05-07T12:48:45.022Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['xpcproxy application.Appify by Machine Box.My Go Application.20.23'],
        'host.risk.calculated_level': ['High'],
        _id: ['4615c3a90e8057ae5cc9b358bbbf4298e346277a2f068dda052b0b43ef6d5bbd'],
        'process.hash.sha1': ['58a3bddbc7c45193ecbefa22ad0496b60a29dff2'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:27:47.362Z']
      },
      sort: [99, 1715086125022]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '449322a72d3f19efbdf983935a1bdd21ebd6b9c761ce31e8b252003017d7e5db',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/37D933EC-334D-410A-A741-0F730D6AE3FD/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'process.hash.md5': ['e62bdd3eaf2be436fca2e67b7eede603'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['/sbin/launchd'],
        'process.parent.name': ['launchd'],
        'user.name': ['root'],
        'user.risk.calculated_level': ['Moderate'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'process.code_signature.signing_id': ['a.out'],
        'process.pid': [1123],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['No error.'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': [''],
        'host.os.version': ['13.4'],
        'file.hash.sha256': ['2c63ba2b1a5131b80e567b7a1a93997a2de07ea20d0a8f5149701c67b832c097'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [66.491455],
        'host.os.name': ['macOS'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVMAC08'],
        'process.executable': ['/private/var/folders/_b/rmcpc65j6nv11ygrs50ctcjr0000gn/T/AppTranslocation/37D933EC-334D-410A-A741-0F730D6AE3FD/d/Setup.app/Contents/MacOS/My Go Application.app'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.parent.code_signature.subject_name': ['Software Signing'],
        'process.parent.executable': ['/sbin/launchd'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['My Go Application.app'],
        'process.args': ['xpcproxy', 'application.Appify by Machine Box.My Go Application.20.23'],
        'process.code_signature.status': ['code failed to satisfy specified code requirement(s)'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['My Go Application.app'],
        'process.parent.args': ['/sbin/launchd'],
        '@timestamp': ['2024-05-07T12:48:45.020Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['xpcproxy application.Appify by Machine Box.My Go Application.20.23'],
        'host.risk.calculated_level': ['High'],
        _id: ['449322a72d3f19efbdf983935a1bdd21ebd6b9c761ce31e8b252003017d7e5db'],
        'process.hash.sha1': ['58a3bddbc7c45193ecbefa22ad0496b60a29dff2'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-06-19T00:25:24.716Z']
      },
      sort: [99, 1715086125020]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'f465ca9fbfc8bc3b1871e965c9e111cac76ff3f4076fed6bc9da88d49fb43014',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Memory Threat Detection Alert: Shellcode Injection'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'kibana.alert.workflow_status': ['open'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Memory Threat Detection Alert: Shellcode Injection'],
        'process.parent.args_count': [1],
        'process.name': ['MsMpEng.exe'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:45.017Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        _id: ['f465ca9fbfc8bc3b1871e965c9e111cac76ff3f4076fed6bc9da88d49fb43014'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:22.051Z']
      },
      sort: [99, 1715086125017]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'aa283e6a13be77b533eceffb09e48254c8f91feeccc39f7eed80fd3881d053f4',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Windows\\mpsvc.dll'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection', 'library'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['8dd620d9aeb35960bb766458c8890ede987c33d239cf730f93fe49d90ae759dd'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['mpsvc.dll'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['MsMpEng.exe'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:45.008Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        _id: ['aa283e6a13be77b533eceffb09e48254c8f91feeccc39f7eed80fd3881d053f4'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:18.093Z']
      },
      sort: [99, 1715086125008]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'dd9e4ea23961ccfdb7a9c760ee6bedd19a013beac3b0d38227e7ae77ba4ce515',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Windows\\mpsvc.dll'],
        'process.hash.md5': ['561cffbaba71a6e8cc1cdceda990ead4'],
        'event.category': ['malware', 'intrusion_detection', 'file'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['C:\\Windows\\Explorer.EXE'],
        'process.parent.name': ['explorer.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'process.pid': [1008],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['trusted'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['8dd620d9aeb35960bb766458c8890ede987c33d239cf730f93fe49d90ae759dd'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['Microsoft Windows'],
        'process.parent.executable': ['C:\\Windows\\explorer.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['mpsvc.dll'],
        'process.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.code_signature.status': ['errorExpired'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.parent.args': ['C:\\Windows\\Explorer.EXE'],
        '@timestamp': ['2024-05-07T12:48:45.007Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'host.risk.calculated_level': ['High'],
        _id: ['dd9e4ea23961ccfdb7a9c760ee6bedd19a013beac3b0d38227e7ae77ba4ce515'],
        'process.hash.sha1': ['5162f14d75e96edb914d1756349d6e11583db0b0'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:17.887Z']
      },
      sort: [99, 1715086125007]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'f30d55e503b1d848b34ee57741b203d8052360dd873ea34802f3fa7a9ef34d0a',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.hash.md5': ['561cffbaba71a6e8cc1cdceda990ead4'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['C:\\Windows\\Explorer.EXE'],
        'process.parent.name': ['explorer.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'process.pid': [1008],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['trusted'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [false],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['Microsoft Windows'],
        'process.parent.executable': ['C:\\Windows\\explorer.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.code_signature.status': ['errorExpired'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.parent.args': ['C:\\Windows\\Explorer.EXE'],
        '@timestamp': ['2024-05-07T12:48:45.006Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'host.risk.calculated_level': ['High'],
        _id: ['f30d55e503b1d848b34ee57741b203d8052360dd873ea34802f3fa7a9ef34d0a'],
        'process.hash.sha1': ['5162f14d75e96edb914d1756349d6e11583db0b0'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:17.544Z']
      },
      sort: [99, 1715086125006]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '6f8cd5e8021dbb64598f2b7ec56bee21fd00d1e62d4e08905f86bf234873ee66',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.hash.md5': ['f070b5cf25febb9a88a168efd87c6112'],
        'event.category': ['malware', 'intrusion_detection', 'file'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': [''],
        'process.parent.name': ['userinit.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['567be4d1e15f4ff96d92e7d28e191076f5813f50be96bf4c3916e4ecf53f66cd'],
        'process.pid': [6228],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['trusted'],
        'process.pe.original_file_name': ['EXPLORER.EXE'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Windows'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\explorer.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['Microsoft Windows'],
        'process.parent.executable': ['C:\\Windows\\System32\\userinit.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.args': ['C:\\Windows\\Explorer.EXE'],
        'process.code_signature.status': ['trusted'],
        message: ['Malware Detection Alert'],
        'process.name': ['explorer.exe'],
        '@timestamp': ['2024-05-07T12:48:45.004Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['C:\\Windows\\Explorer.EXE'],
        'host.risk.calculated_level': ['High'],
        _id: ['6f8cd5e8021dbb64598f2b7ec56bee21fd00d1e62d4e08905f86bf234873ee66'],
        'process.hash.sha1': ['94518c310478e494082418ed295466f5aea26eea'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:37:18.152Z']
      },
      sort: [99, 1715086125004]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'ce110da958fe0cf0c07599a21c68d90a64c93b7607aa27970a614c7f49598316',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'process.hash.md5': ['f070b5cf25febb9a88a168efd87c6112'],
        'event.category': ['malware', 'intrusion_detection', 'file'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': [''],
        'process.parent.name': ['userinit.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['567be4d1e15f4ff96d92e7d28e191076f5813f50be96bf4c3916e4ecf53f66cd'],
        'process.pid': [6228],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['trusted'],
        'process.pe.original_file_name': ['EXPLORER.EXE'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Windows'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\explorer.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['Microsoft Windows'],
        'process.parent.executable': ['C:\\Windows\\System32\\userinit.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e'],
        'process.args': ['C:\\Windows\\Explorer.EXE'],
        'process.code_signature.status': ['trusted'],
        message: ['Malware Detection Alert'],
        'process.name': ['explorer.exe'],
        '@timestamp': ['2024-05-07T12:48:45.001Z'],
        'process.parent.code_signature.trusted': [true],
        'process.command_line': ['C:\\Windows\\Explorer.EXE'],
        'host.risk.calculated_level': ['High'],
        _id: ['ce110da958fe0cf0c07599a21c68d90a64c93b7607aa27970a614c7f49598316'],
        'process.hash.sha1': ['94518c310478e494082418ed295466f5aea26eea'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:36:43.813Z']
      },
      sort: [99, 1715086125001]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '0866787b0027b4d908767ac16e35a1da00970c83632ba85be65f2ad371132b4f',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection', 'process', 'file'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Ransomware Detection Alert'],
        'host.name': ['SRVWIN02'],
        'Ransomware.files.data': ['2D002D002D003D003D003D0020005700', '2D002D002D003D003D003D0020005700', '2D002D002D003D003D003D0020005700'],
        'process.code_signature.trusted': [true],
        'Ransomware.files.metrics': ['CANARY_ACTIVITY'],
        'kibana.alert.workflow_status': ['open'],
        'process.parent.args_count': [1],
        'process.name': ['MsMpEng.exe'],
        'Ransomware.files.score': [0, 0, 0],
        'process.parent.code_signature.trusted': [false],
        _id: ['0866787b0027b4d908767ac16e35a1da00970c83632ba85be65f2ad371132b4f'],
        'Ransomware.version': ['1.6.0'],
        'user.name': ['Administrator'],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'Ransomware.files.operation': ['creation', 'creation', 'creation'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'process.Ext.token.integrity_level_name': ['high'],
        'Ransomware.files.path': ['c:\\hd3vuk19y-readme.txt', 'c:\\$winreagent\\hd3vuk19y-readme.txt', 'c:\\aaantiransomelastic-do-not-touch-dab6d40c-a6a1-442c-adc4-9d57a47e58d7\\hd3vuk19y-readme.txt'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'Ransomware.files.entropy': [3.629971457026797, 3.629971457026797, 3.629971457026797],
        'Ransomware.feature': ['canary'],
        'Ransomware.files.extension': ['txt', 'txt', 'txt'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Ransomware Detection Alert'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:45.000Z'],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:22.964Z']
      },
      sort: [99, 1715086125000]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'b0fdf96721e361e1137d49a67e26d92f96b146392d7f44322bddc3d660abaef1',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Memory Threat Detection Alert: Shellcode Injection'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'kibana.alert.workflow_status': ['open'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Memory Threat Detection Alert: Shellcode Injection'],
        'process.parent.args_count': [1],
        'process.name': ['MsMpEng.exe'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:44.996Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        _id: ['b0fdf96721e361e1137d49a67e26d92f96b146392d7f44322bddc3d660abaef1'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:22.174Z']
      },
      sort: [99, 1715086124996]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '7b4f49f21cf141e67856d3207fb4ea069c8035b41f0ea501970694cf8bd43cbe',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Memory Threat Detection Alert: Shellcode Injection'],
        'host.name': ['SRVWIN02'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'kibana.alert.workflow_status': ['open'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Memory Threat Detection Alert: Shellcode Injection'],
        'process.parent.args_count': [1],
        'process.name': ['MsMpEng.exe'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:44.986Z'],
        'process.parent.code_signature.trusted': [false],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        _id: ['7b4f49f21cf141e67856d3207fb4ea069c8035b41f0ea501970694cf8bd43cbe'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:22.066Z']
      },
      sort: [99, 1715086124986]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'ea81d79104cbd442236b5bcdb7a3331de897aa4ce1523e622068038d048d0a9e',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['8cc83221870dd07144e63df594c391d9'],
        'event.category': ['malware', 'intrusion_detection', 'process'],
        'host.risk.calculated_score_norm': [75.62723],
        'process.parent.command_line': ['"C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe" '],
        'process.parent.name': ['d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['33bc14d231a4afaa18f06513766d5f69d8b88f1e697cd127d24fb4b72ad44c7a'],
        'process.Ext.memory_region.malware_signature.primary.matches': ['WVmF9nQli1UIg2YEAIk+iwoLSgQ=', 'dQxy0zPAQF9eW4vlXcMzwOv1VYvsgw==', 'DIsEsIN4BAV1HP9wCP9wDP91DP8=', '+4tF/FCLCP9RCF6Lx19bi+Vdw1U=', 'vAAAADPSi030i/GLRfAPpMEBwe4f', 'VIvO99GLwiNN3PfQM030I8czReiJ', 'DIlGDIXAdSozwOtsi0YIhcB0Yms='],
        'process.pid': [8708],
        'process.code_signature.exists': [true],
        'process.code_signature.subject_name': ['Microsoft Corporation'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Memory Threat Detection Alert: Windows.Ransomware.Sodinokibi'],
        'host.name': ['SRVWIN02'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'kibana.alert.workflow_status': ['open'],
        'rule.name': ['Windows.Ransomware.Sodinokibi'],
        'process.parent.args_count': [1],
        'process.Ext.memory_region.bytes_compressed_present': [false],
        'process.name': ['MsMpEng.exe'],
        'process.parent.code_signature.trusted': [false],
        _id: ['ea81d79104cbd442236b5bcdb7a3331de897aa4ce1523e622068038d048d0a9e'],
        'user.name': ['Administrator'],
        'process.parent.code_signature.exists': [true],
        'process.parent.code_signature.status': ['errorExpired'],
        'process.pe.original_file_name': ['MsMpEng.exe'],
        'event.module': ['endpoint'],
        'process.Ext.memory_region.malware_signature.all_names': ['Windows.Ransomware.Sodinokibi'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\MsMpEng.exe'],
        'process.Ext.memory_region.malware_signature.primary.signature.name': ['Windows.Ransomware.Sodinokibi'],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.code_signature.subject_name': ['PB03 TRANSPORT LTD.'],
        'process.parent.executable': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        'process.args': ['C:\\Windows\\MsMpEng.exe'],
        'process.code_signature.status': ['trusted'],
        message: ['Memory Threat Detection Alert: Windows.Ransomware.Sodinokibi'],
        'process.parent.args': ['C:\\Users\\Administrator\\Desktop\\8813719803\\d55f983c994caa160ec63a59f6b4250fe67fb3e8c43a388aec60a4a6978e9f1e.exe'],
        '@timestamp': ['2024-05-07T12:48:44.975Z'],
        'process.command_line': ['"C:\\Windows\\MsMpEng.exe"'],
        'host.risk.calculated_level': ['High'],
        'process.hash.sha1': ['3d409b39b8502fcd23335a878f2cbdaf6d721995'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-20T23:38:25.169Z']
      },
      sort: [99, 1715086124975]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: 'cdf3b5510bb5ed622e8cefd1ce6bedc52bdd99a4c1ead537af0603469e713c8b',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'file.path': ['C:\\Users\\Administrator\\AppData\\Local\\cdnver.dll'],
        'process.hash.md5': ['4bfef0b578515c16b9582e32b78d2594'],
        'event.category': ['malware', 'intrusion_detection', 'library'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['C:\\Programdata\\Q3C7N1V8.exe'],
        'process.parent.name': ['Q3C7N1V8.exe'],
        'user.name': ['Administrator'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['70d21cbdc527559c4931421e66aa819b86d5af5535445ace467e74518164c46a'],
        'process.pid': [7824],
        'process.code_signature.exists': [true],
        'process.parent.code_signature.exists': [false],
        'process.pe.original_file_name': ['RUNDLL32.EXE'],
        'event.module': ['endpoint'],
        'process.code_signature.subject_name': ['Microsoft Windows'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'file.hash.sha256': ['12e6642cf6413bdf5388bee663080fa299591b2ba023d069286f3be9647547c8'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malware Detection Alert'],
        'host.name': ['SRVWIN01'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\SysWOW64\\rundll32.exe'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.executable': ['C:\\ProgramData\\Q3C7N1V8.exe'],
        'kibana.alert.workflow_status': ['open'],
        'file.name': ['cdnver.dll'],
        'process.args': ['C:\\Windows\\System32\\rundll32.exe', 'C:\\Users\\Administrator\\AppData\\Local\\cdnver.dll,#1'],
        'process.code_signature.status': ['trusted'],
        message: ['Malware Detection Alert'],
        'process.parent.args_count': [1],
        'process.name': ['rundll32.exe'],
        'process.parent.args': ['C:\\Programdata\\Q3C7N1V8.exe'],
        '@timestamp': ['2024-05-07T12:47:32.838Z'],
        'process.command_line': ['"C:\\Windows\\System32\\rundll32.exe" "C:\\Users\\Administrator\\AppData\\Local\\cdnver.dll",#1'],
        'host.risk.calculated_level': ['High'],
        _id: ['cdf3b5510bb5ed622e8cefd1ce6bedc52bdd99a4c1ead537af0603469e713c8b'],
        'process.hash.sha1': ['9b16507aaf10a0aafa0df2ba83e8eb2708d83a02'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-16T01:51:26.472Z']
      },
      sort: [99, 1715086052838]
    }, {
      _index: '.internal.alerts-security.alerts-default-000001',
      _id: '6abe81eb6350fb08031761be029e7ab19f7e577a7c17a9c5ea1ed010ba1620e3',
      _score: null,
      fields: {
        'kibana.alert.severity': ['critical'],
        'process.hash.md5': ['4bfef0b578515c16b9582e32b78d2594'],
        'event.category': ['malware', 'intrusion_detection'],
        'host.risk.calculated_score_norm': [73.02488],
        'process.parent.command_line': ['C:\\Programdata\\Q3C7N1V8.exe'],
        'process.parent.name': ['Q3C7N1V8.exe'],
        'user.risk.calculated_level': ['High'],
        'kibana.alert.rule.description': ['Generates a detection alert each time an Elastic Endpoint Security alert is received. Enabling this rule allows you to immediately begin investigating your Endpoint alerts.'],
        'process.hash.sha256': ['70d21cbdc527559c4931421e66aa819b86d5af5535445ace467e74518164c46a'],
        'process.pid': [7824],
        'process.code_signature.exists': [true],
        'process.code_signature.subject_name': ['Microsoft Windows'],
        'host.os.version': ['21H2 (10.0.20348.1366)'],
        'kibana.alert.risk_score': [99],
        'user.risk.calculated_score_norm': [82.16188],
        'host.os.name': ['Windows'],
        'kibana.alert.rule.name': ['Malicious Behavior Detection Alert: RunDLL32 with Unusual Arguments'],
        'host.name': ['SRVWIN01'],
        'event.outcome': ['success'],
        'process.code_signature.trusted': [true],
        'kibana.alert.workflow_status': ['open'],
        'rule.name': ['RunDLL32 with Unusual Arguments'],
        'threat.tactic.id': ['TA0005'],
        'threat.tactic.name': ['Defense Evasion'],
        'threat.technique.id': ['T1218'],
        'process.parent.args_count': [1],
        'threat.technique.subtechnique.reference': ['https://attack.mitre.org/techniques/T1218/011/'],
        'process.name': ['rundll32.exe'],
        'threat.technique.subtechnique.name': ['Rundll32'],
        _id: ['6abe81eb6350fb08031761be029e7ab19f7e577a7c17a9c5ea1ed010ba1620e3'],
        'threat.technique.name': ['System Binary Proxy Execution'],
        'threat.tactic.reference': ['https://attack.mitre.org/tactics/TA0005/'],
        'user.name': ['Administrator'],
        'threat.framework': ['MITRE ATT&CK'],
        'process.working_directory': ['C:\\Users\\Administrator\\Documents\\'],
        'process.pe.original_file_name': ['RUNDLL32.EXE'],
        'event.module': ['endpoint'],
        'user.domain': ['OMM-WIN-DETECT'],
        'process.executable': ['C:\\Windows\\SysWOW64\\rundll32.exe'],
        'process.Ext.token.integrity_level_name': ['high'],
        'process.parent.executable': ['C:\\ProgramData\\Q3C7N1V8.exe'],
        'process.args': ['C:\\Windows\\System32\\rundll32.exe', 'C:\\Users\\Administrator\\AppData\\Local\\cdnver.dll,#1'],
        'process.code_signature.status': ['trusted'],
        message: ['Malicious Behavior Detection Alert: RunDLL32 with Unusual Arguments'],
        'process.parent.args': ['C:\\Programdata\\Q3C7N1V8.exe'],
        '@timestamp': ['2024-05-07T12:47:32.836Z'],
        'threat.technique.subtechnique.id': ['T1218.011'],
        'threat.technique.reference': ['https://attack.mitre.org/techniques/T1218/'],
        'process.command_line': ['"C:\\Windows\\System32\\rundll32.exe" "C:\\Users\\Administrator\\AppData\\Local\\cdnver.dll",#1'],
        'host.risk.calculated_level': ['High'],
        'process.hash.sha1': ['9b16507aaf10a0aafa0df2ba83e8eb2708d83a02'],
        'event.dataset': ['endpoint.alerts'],
        'kibana.alert.original_time': ['2023-01-16T01:51:26.348Z']
      },
      sort: [99, 1715086052836]
    }]
  }
};