"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetDocViewer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createGetDocViewer = indexes => prev => params => {
  const prevDocViewer = prev(params);
  const tabTitle = _i18n.i18n.translate('discover.docViews.observability.traces.spanOverview.title', {
    defaultMessage: 'Span overview'
  });
  return {
    ...prevDocViewer,
    docViewsRegistry: registry => {
      registry.add({
        id: 'doc_view_obs_traces_span_overview',
        title: tabTitle,
        order: 0,
        component: props => {
          return /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewerObservabilityTracesSpanOverview, (0, _extends2.default)({}, props, {
            indexes: indexes
          }));
        }
      });
      return prevDocViewer.docViewsRegistry(registry);
    }
  };
};
exports.createGetDocViewer = createGetDocViewer;