"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionBarWarning = ActionBarWarning;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _context = require("../../services/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ActionBarWarning({
  docCount,
  type
}) {
  if (type === _context.SurrDocType.PREDECESSORS) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "primary",
      "data-test-subj": "predecessorsWarningMsg",
      iconType: "info",
      title: docCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.context.newerDocumentsWarningZero",
        defaultMessage: "No documents newer than the anchor could be found."
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "discover.context.newerDocumentsWarning",
        defaultMessage: "Only {docCount} documents newer than the anchor could be found.",
        values: {
          docCount
        }
      }),
      size: "s"
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "primary",
    "data-test-subj": "successorsWarningMsg",
    iconType: "info",
    title: docCount === 0 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.olderDocumentsWarningZero",
      defaultMessage: "No documents older than the anchor could be found."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.context.olderDocumentsWarning",
      defaultMessage: "Only {docCount} documents older than the anchor could be found.",
      values: {
        docCount
      }
    }),
    size: "s"
  });
}