/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.datasetQuality_bundle_jsonpfunction=self.datasetQuality_bundle_jsonpfunction||[]).push([[88],{4088:(t,a,e)=>{e.d(a,{DataStreamDetailsClient:()=>DataStreamDetailsClient});var d=e(6524),s=e(744),r=e(6927),i=e(4631);class DataStreamDetailsClient{constructor(t){this.http=t}async getDataStreamSettings({dataStream:t}){const a=await this.http.get(`/internal/dataset_quality/data_streams/${t}/settings`).catch((t=>{throw new i._(`Failed to fetch data stream settings": ${t}`,t)}));return(0,d.GB)(s.wf,(t=>new i._(`Failed to decode data stream settings response: ${t}"`)))(a)}async getDataStreamDetails({dataStream:t,start:a,end:e}){const r=await this.http.get(`/internal/dataset_quality/data_streams/${t}/details`,{query:{start:a,end:e}}).catch((t=>{throw new i._(`Failed to fetch data stream details": ${t}`,t)}));return(0,d.GB)(s.vM,(t=>new i._(`Failed to decode data stream details response: ${t}"`)))(r)}async getFailedDocsDetails({dataStream:t,start:a,end:e}){const r=await this.http.get(`/internal/dataset_quality/data_streams/${t}/failed_docs`,{query:{start:a,end:e}}).catch((t=>{throw new i._(`Failed to fetch data stream failed docs details": ${t}`,t)}));return(0,d.GB)(s.Mc,(t=>new i._(`Failed to decode data stream failed docs details response: ${t}"`)))(r)}async getFailedDocsErrors({dataStream:t,start:a,end:e}){const r=await this.http.get(`/internal/dataset_quality/data_streams/${t}/failed_docs/errors`,{query:{start:a,end:e}}).catch((t=>{throw new i._(`Failed to fetch data stream failed docs details": ${t}`,t)}));return(0,d.GB)(s.qJ,(t=>new i._(`Failed to decode data stream failed docs details response: ${t}"`)))(r)}async getDataStreamDegradedFields({dataStream:t,start:a,end:e}){const r=await this.http.get(`/internal/dataset_quality/data_streams/${t}/degraded_fields`,{query:{start:a,end:e}}).catch((t=>{throw new i._(`Failed to fetch data stream degraded fields": ${t}`,t)}));return(0,d.GB)(s.Xz,(t=>new i._(`Failed to decode data stream degraded fields response: ${t}"`)))(r)}async getDataStreamDegradedFieldValues({dataStream:t,degradedField:a}){const e=await this.http.get(`/internal/dataset_quality/data_streams/${t}/degraded_field/${a}/values`).catch((t=>{throw new i._(`Failed to fetch data stream degraded field Value": ${t}`,t)}));return(0,d.GB)(s.lU,(t=>new i._(`Failed to decode data stream degraded field values response: ${t}"`)))(e)}async checkAndLoadIntegration({dataStream:t}){const a=await this.http.get(`/internal/dataset_quality/data_streams/${t}/integration/check`).catch((t=>{throw new i._(`Failed to check if data stream belongs to an integration": ${t}`,t)})),e=(0,d.GB)(s.Tu,(t=>new i._(`Failed to decode integration check response: ${t}"`)))(a);return{...e,integration:e.isIntegration?r.n.create(e.integration):void 0}}async getIntegrationDashboards({integration:t}){const a=await this.http.get(`/internal/dataset_quality/integrations/${t}/dashboards`).catch((t=>{throw new i._(`Failed to fetch integration dashboards": ${t}`,t)})),{dashboards:e}=(0,d.GB)(s.Cj,(t=>new i._(`Failed to decode integration dashboards response: ${t}"`)))(a);return e}async analyzeDegradedField({dataStream:t,degradedField:a,lastBackingIndex:e}){const r=await this.http.get(`/internal/dataset_quality/data_streams/${t}/degraded_field/${a}/analyze`,{query:{lastBackingIndex:e}}).catch((e=>{throw new i._(`Failed to analyze degraded field: ${a} for datastream: ${t}`,e)}));return(0,d.GB)(s.RA,(t=>new i._(`Failed to decode the analysis response: ${t}`)))(r)}async setNewFieldLimit({dataStream:t,newFieldLimit:a}){const e=await this.http.put(`/internal/dataset_quality/data_streams/${t}/update_field_limit`,{body:JSON.stringify({newFieldLimit:a})}).catch((t=>{throw new i._(`Failed to set new Limit: ${t.message}`,t)}));return(0,d.GB)(s.oI,(t=>new i._(`Failed to decode setting of new limit response: ${t}"`)))(e)}async rolloverDataStream({dataStream:t}){const a=await this.http.post(`/internal/dataset_quality/data_streams/${t}/rollover`).catch((t=>{throw new i._(`Failed to rollover datastream": ${t}`,t)}));return(0,d.GB)(s.LN,(t=>new i._(`Failed to decode rollover response: ${t}"`)))(a)}}}}]);