"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettings = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _combined_fields = require("../../../../common/components/combined_fields");
var _create_data_view_tooltip = require("../create_data_view_tooltip");
var _inputs = require("./inputs");
var _semantic_text_info = require("../semantic_text_info");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedSettings = ({
  index,
  dataView,
  initialized,
  onIndexChange,
  createDataView,
  onCreateDataViewChange,
  onDataViewChange,
  indexSettingsString,
  mappingsString,
  pipelineString,
  onIndexSettingsStringChange,
  onMappingsStringChange,
  onPipelineStringChange,
  indexNameError,
  dataViewNameError,
  combinedFields,
  onCombinedFieldsChange,
  results,
  canCreateDataView
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.indexNameLabel",
      defaultMessage: "Index name"
    }),
    isInvalid: indexNameError !== '',
    error: [indexNameError]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: _i18n.i18n.translate('xpack.dataVisualizer.file.advancedImportSettings.indexNamePlaceholder', {
      defaultMessage: 'index name'
    }),
    value: index,
    disabled: initialized === true,
    onChange: e => onIndexChange(e.target.value),
    isInvalid: indexNameError !== '',
    "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.file.advancedImportSettings.indexNameAriaLabel', {
      defaultMessage: 'Index name, required field'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_create_data_view_tooltip.CreateDataViewToolTip, {
    showTooltip: canCreateDataView === false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "createDataView",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.createDataViewLabel",
      defaultMessage: "Create data view"
    }),
    checked: createDataView === true,
    disabled: initialized === true || canCreateDataView === false,
    onChange: onCreateDataViewChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.advancedImportSettings.dataViewNameLabel",
      defaultMessage: "Data view name"
    }),
    isInvalid: dataViewNameError !== '',
    error: [dataViewNameError]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: createDataView === false || initialized === true,
    placeholder: createDataView === true ? index : '',
    value: dataView,
    onChange: onDataViewChange,
    isInvalid: dataViewNameError !== ''
  })), /*#__PURE__*/_react.default.createElement(_semantic_text_info.SemanticTextInfo, {
    results: results
  }), /*#__PURE__*/_react.default.createElement(_combined_fields.CombinedFieldsForm, {
    mappingsString: mappingsString,
    pipelineString: pipelineString,
    onMappingsStringChange: onMappingsStringChange,
    onPipelineStringChange: onPipelineStringChange,
    combinedFields: combinedFields,
    onCombinedFieldsChange: onCombinedFieldsChange,
    results: results,
    isDisabled: initialized === true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inputs.IndexSettings, {
    initialized: initialized,
    data: indexSettingsString,
    onChange: onIndexSettingsStringChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inputs.Mappings, {
    initialized: initialized,
    data: mappingsString,
    onChange: onMappingsStringChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_inputs.IngestPipeline, {
    initialized: initialized,
    data: pipelineString,
    onChange: onPipelineStringChange
  }))));
};
exports.AdvancedSettings = AdvancedSettings;