"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportErrors = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _import_progress = require("../import_progress");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ImportErrors = ({
  errors,
  statuses
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: title(statuses),
    color: "danger",
    iconType: "cross"
  }, errors.map((e, i) => /*#__PURE__*/_react.default.createElement(ImportError, {
    error: e,
    key: i
  })));
};
exports.ImportErrors = ImportErrors;
function title(statuses) {
  switch (_import_progress.IMPORT_STATUS.FAILED) {
    case statuses.readStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.readingFileErrorMessage",
        defaultMessage: "Error reading file"
      });
    case statuses.parseJSONStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.parsingJSONErrorMessage",
        defaultMessage: "Error parsing JSON"
      });
    case statuses.indexCreatedStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.creatingIndexErrorMessage",
        defaultMessage: "Error creating index"
      });
    case statuses.ingestPipelineCreatedStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.creatingIngestPipelineErrorMessage",
        defaultMessage: "Error creating ingest pipeline"
      });
    case statuses.uploadStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.uploadingDataErrorMessage",
        defaultMessage: "Error uploading data"
      });
    case statuses.dataViewCreatedStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.creatingDataViewErrorMessage",
        defaultMessage: "Error creating data view"
      });
    case statuses.permissionCheckStatus:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.checkingPermissionErrorMessage",
        defaultMessage: "Import permissions error"
      });
    default:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.file.importErrors.defaultErrorMessage",
        defaultMessage: "Error"
      });
  }
}
const ImportError = ({
  error
}) => {
  const errorObj = toString(error);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, errorObj.msg), errorObj.more !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "more",
    buttonContent: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.file.importErrors.moreButtonLabel",
      defaultMessage: "More"
    }),
    paddingSize: "m"
  }, errorObj.more));
};
function toString(error) {
  if (typeof error === 'string') {
    return {
      msg: error
    };
  }
  if (typeof error === 'object') {
    if (error.msg !== undefined) {
      return {
        msg: error.msg
      };
    } else if (error.error !== undefined) {
      if (typeof error.error === 'object') {
        var _error$error$reason;
        // this will catch a bulk ingest failure
        const reason = (_error$error$reason = error.error.reason) !== null && _error$error$reason !== void 0 ? _error$error$reason : error.error.meta.body.error.reason;
        if (reason !== undefined) {
          var _error$error$root_cau;
          const errorObj = {
            msg: reason
          };
          const rootCause = (_error$error$root_cau = error.error.root_cause) !== null && _error$error$root_cau !== void 0 ? _error$error$root_cau : error.error.meta.body.error.root_cause;
          if (rootCause !== undefined) {
            errorObj.more = JSON.stringify(rootCause);
          }
          return errorObj;
        }

        // this will catch javascript errors such as JSON parsing issues
        if (error.error.message !== undefined) {
          return {
            msg: error.error.message
          };
        }
      } else {
        return {
          msg: error.error
        };
      }
    } else {
      // last resort, just display the whole object
      return {
        msg: JSON.stringify(error)
      };
    }
  }
  return {
    msg: _i18n.i18n.translate('xpack.dataVisualizer.file.importErrors.unknownErrorMessage', {
      defaultMessage: 'Unknown error'
    })
  };
}