"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartsFilters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../translations");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _date_picker = require("./date_picker");
var _charts_filter = require("./charts_filter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartsFilters = exports.ChartsFilters = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  isUpdateDisabled,
  isValidDateRange,
  filterOptions,
  onClick,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  showMetricsTypesFilter = false,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const filters = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showMetricsTypesFilter && /*#__PURE__*/_react.default.createElement(_charts_filter.ChartsFilter, {
      filterOptions: filterOptions.metricTypes,
      "data-test-subj": dataTestSubj
    }), !filterOptions.dataStreams.isFilterLoading && /*#__PURE__*/_react.default.createElement(_charts_filter.ChartsFilter, {
      filterOptions: filterOptions.dataStreams,
      "data-test-subj": dataTestSubj
    }));
  }, [dataTestSubj, filterOptions, showMetricsTypesFilter]);
  const onClickRefreshButton = (0, _react.useCallback)(() => onClick(), [onClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: true,
    gutterSize: "m",
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, filters)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_date_picker.UsageMetricsDateRangePicker, {
    dateRangePickerState: dateRangePickerState,
    isDataLoading: isDataLoading,
    onRefresh: onRefresh,
    onRefreshChange: onRefreshChange,
    onTimeChange: onTimeChange,
    "data-test-subj": dataTestSubj
  }), !isValidDateRange && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "danger",
    size: "s",
    "data-test-subj": getTestId('invalid-date-range')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("p", null, _translations.UX_LABELS.filters.invalidDateRange)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
    "data-test-subj": getTestId('super-refresh-button'),
    fill: false,
    isLoading: isDataLoading,
    isDisabled: isUpdateDisabled,
    onClick: onClickRefreshButton
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2
  }));
});
ChartsFilters.displayName = 'ChartsFilters';