"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatSessionName = formatSessionName;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function formatSessionName(sessionName, opts) {
  if (opts.sessionStartTime && opts.appendStartTime) {
    sessionName = appendDate(sessionName, opts.sessionStartTime);
  }
  return sessionName;
}
function appendDate(sessionName, sessionStartTime) {
  return `${sessionName} - ${(0, _moment.default)(sessionStartTime).format(`L @ LT`)}`;
}