"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiFieldKey = exports.MULTI_FIELD_KEY_SEPARATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _serializable_field = require("../../../serializable_field");
var _serialize_utils = require("../../../serialize_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Serialized form of {@link @kbn/data-plugin/common.MultiFieldKey}
 */

const isBucketLike = bucket => {
  return Boolean(bucket && typeof bucket === 'object' && 'key' in bucket);
};
function getKeysFromBucket(bucket) {
  if (!isBucketLike(bucket)) {
    throw new Error('bucket malformed - no key found');
  }
  return Array.isArray(bucket.key) ? bucket.key.map(String) : [String(bucket.key)];
}
class MultiFieldKey extends _serializable_field.SerializableField {
  static isInstance(field) {
    return field instanceof MultiFieldKey;
  }
  static deserialize(value) {
    return new MultiFieldKey({
      key: value.keys // key here is to keep bwc with constructor params
    });
  }
  static idBucket(bucket) {
    return getKeysFromBucket(bucket).join(',');
  }
  constructor(bucket) {
    super();
    (0, _defineProperty2.default)(this, "keys", void 0);
    this.keys = getKeysFromBucket(bucket);
  }
  toString() {
    return this.keys.join(',');
  }
  serialize() {
    return {
      type: _serialize_utils.SerializableType.MultiFieldKey,
      keys: this.keys
    };
  }
}

/**
 * Multi-field key separator used in Visualizations (Lens, AggBased, TSVB).
 * This differs from the separator used in the toString method of the MultiFieldKey
 */
exports.MultiFieldKey = MultiFieldKey;
const MULTI_FIELD_KEY_SEPARATOR = exports.MULTI_FIELD_KEY_SEPARATOR = ' › ';