"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractControlGroupState = extractControlGroupState;
var _common = require("@kbn/controls-plugin/common");
var _public = require("@kbn/controls-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function extractControlGroupState(state) {
  if (state.controlGroupState && typeof state.controlGroupState === 'object') {
    // URL state created in 8.16 through 8.18 passed control group runtime state in with controlGroupState key
    return (0, _public.serializeRuntimeState)(state.controlGroupState).rawState;
  }
  if (!state.controlGroupInput || typeof state.controlGroupInput !== 'object') return;
  const controlGroupInput = state.controlGroupInput;
  let autoApplySelections = _common.DEFAULT_AUTO_APPLY_SELECTIONS;
  if (typeof controlGroupInput.autoApplySelections === 'boolean') {
    autoApplySelections = controlGroupInput.autoApplySelections;
  } else if (typeof controlGroupInput.showApplySelections === 'boolean') {
    // <8.16 autoApplySelections exported as !showApplySelections
    autoApplySelections = !controlGroupInput.showApplySelections;
  }
  let controls = [];
  if (Array.isArray(controlGroupInput.controls)) {
    controls = controlGroupInput.controls;
  } else if (controlGroupInput.panels && typeof controlGroupInput.panels === 'object') {
    // <8.16 controls exported as panels
    const panels = controlGroupInput.panels;
    controls = Object.keys(controlGroupInput.panels).map(controlId => {
      var _panels$controlId;
      const {
        explicitInput,
        ...restOfControlState
      } = (_panels$controlId = panels[controlId]) !== null && _panels$controlId !== void 0 ? _panels$controlId : {};
      return {
        ...restOfControlState,
        controlConfig: explicitInput
      };
    });
  }
  let labelPosition = _common.DEFAULT_CONTROL_LABEL_POSITION;
  if (typeof controlGroupInput.labelPosition === 'string') {
    labelPosition = controlGroupInput.labelPosition;
  } else if (typeof controlGroupInput.controlStyle === 'string') {
    // <8.16 labelPosition exported as controlStyle
    labelPosition = controlGroupInput.controlStyle;
  }
  return {
    autoApplySelections,
    controls,
    chainingSystem: controlGroupInput.chainingSystem,
    labelPosition,
    ...(controlGroupInput.ignoreParentSettings && typeof controlGroupInput.ignoreParentSettings === 'object' ? {
      ignoreParentSettings: controlGroupInput.ignoreParentSettings
    } : {})
  };
}