"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMenuItemGroups = getMenuItemGroups;
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/embeddable-plugin/public");
var _kibana_services = require("../../../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function getMenuItemGroups(api) {
  const groups = {};
  const addPanelContext = {
    embeddable: api,
    trigger: _public.addPanelMenuTrigger
  };
  function pushItem(group, item) {
    if (!groups[group.id]) {
      var _group$getDisplayName, _group$getDisplayName2, _group$order;
      groups[group.id] = {
        id: group.id,
        title: (_group$getDisplayName = (_group$getDisplayName2 = group.getDisplayName) === null || _group$getDisplayName2 === void 0 ? void 0 : _group$getDisplayName2.call(group, addPanelContext)) !== null && _group$getDisplayName !== void 0 ? _group$getDisplayName : '',
        'data-test-subj': `dashboardEditorMenu-${group.id}Group`,
        order: (_group$order = group.order) !== null && _group$order !== void 0 ? _group$order : 0,
        items: []
      };
    }
    groups[group.id].items.push(item);
  }
  (await _kibana_services.uiActionsService.getTriggerCompatibleActions(_public.ADD_PANEL_TRIGGER, {
    embeddable: api
  })).forEach(action => {
    const actionGroups = Array.isArray(action.grouping) ? action.grouping : [_public2.ADD_PANEL_OTHER_GROUP];
    actionGroups.forEach(group => {
      var _action$getIconType, _action$getIconType2, _action$getDisplayNam, _action$order;
      const actionName = action.getDisplayName(addPanelContext);
      pushItem(group, {
        id: action.id,
        name: actionName,
        icon: (_action$getIconType = (_action$getIconType2 = action.getIconType) === null || _action$getIconType2 === void 0 ? void 0 : _action$getIconType2.call(action, addPanelContext)) !== null && _action$getIconType !== void 0 ? _action$getIconType : 'empty',
        onClick: event => {
          api.clearOverlays();
          if (event.currentTarget instanceof HTMLAnchorElement) {
            if (!event.defaultPrevented &&
            // onClick prevented default
            event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
              event.preventDefault();
            }
          }
          action.execute(addPanelContext);
        },
        'data-test-subj': `create-action-${actionName}`,
        description: action === null || action === void 0 ? void 0 : (_action$getDisplayNam = action.getDisplayNameTooltip) === null || _action$getDisplayNam === void 0 ? void 0 : _action$getDisplayNam.call(action, addPanelContext),
        order: (_action$order = action.order) !== null && _action$order !== void 0 ? _action$order : 0
      });
    });
  });
  return Object.values(groups).map(group => {
    group.items.sort((itemA, itemB) => {
      return itemA.order === itemB.order ? itemA.name.localeCompare(itemB.name) : itemB.order - itemA.order;
    });
    return group;
  }).sort((groupA, groupB) => groupB.order - groupA.order);
}