"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplacementCard = void 0;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _services = require("../../services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/** @jsxRuntime classic */
/** @jsx jsx */

// TODO - clintandrewhall: should use doc-links service
const URL_COMPARISON = 'https://ela.st/beats-agent-comparison';
const idGenerator = (0, _eui.htmlIdGenerator)('replacementCard');
const alsoAvailable = _i18n.i18n.translate('customIntegrations.components.replacementAccordionLabel', {
  defaultMessage: 'Also available in Beats'
});
const link = (0, _react.jsx)(_eui.EuiLink, {
  href: URL_COMPARISON,
  "data-test-subj": "customIntegrationsBeatsAgentComparisonLink",
  external: true
}, (0, _react.jsx)(_i18nReact.FormattedMessage, {
  id: "customIntegrations.components.replacementAccordion.comparisonPageLinkLabel",
  defaultMessage: "comparison page"
}));

/**
 * A pure component, an accordion panel which can display information about replacements for a given EPR module.
 */
const ReplacementCard = ({
  replacements
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    getAbsolutePath
  } = (0, _services.usePlatformService)();
  if (replacements.length === 0) {
    return null;
  }
  const buttons = replacements.map((replacement, index) => (0, _react.jsx)(_eui.EuiFlexItem, {
    grow: false,
    key: `button-${index}`
  }, (0, _react.jsx)("span", null, (0, _react.jsx)(_eui.EuiButton, {
    key: replacement.id,
    href: getAbsolutePath(replacement.uiInternalPath),
    fullWidth: false,
    size: "s"
  }, replacement.title))));
  return (0, _react.jsx)("div", {
    css: (0, _react.css)`
        & .euiAccordion__button {
          color: ${euiTheme.colors.link};
        }
        & .euiAccordion-isOpen .euiAccordion__childWrapper {
          margin-top: ${euiTheme.size.m};
        }
      `
  }, (0, _react.jsx)(_eui.EuiAccordion, {
    id: idGenerator(),
    buttonContent: alsoAvailable,
    paddingSize: "none"
  }, (0, _react.jsx)(_eui.EuiPanel, {
    color: "subdued",
    hasShadow: false,
    paddingSize: "m"
  }, (0, _react.jsx)(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, (0, _react.jsx)(_eui.EuiFlexItem, {
    key: "message"
  }, (0, _react.jsx)(_eui.EuiText, {
    size: "s"
  }, (0, _react.jsx)(_i18nReact.FormattedMessage, {
    id: "customIntegrations.components.replacementAccordion.recommendationDescription",
    defaultMessage: "Elastic Agent Integrations are recommended, but you can also use Beats. For more details, check out our {link}.",
    values: {
      link
    }
  }))), (0, _react.jsx)(_eui.EuiFlexItem, {
    key: "buttons"
  }, (0, _react.jsx)(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, buttons))))));
};
exports.ReplacementCard = ReplacementCard;