"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/index-management-plugin/public");
var _routing = require("../../../../../services/routing");
var _constants = require("../../../../../constants");
var _context_menu = require("../context_menu");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const POLL_INTERVAL_MS = 1000;
const POLL_TIMEOUT_MS = 5000;
const FollowerIndexDetails = ({
  followerIndex,
  isPollingStatus
}) => {
  const {
    remoteCluster,
    leaderIndex,
    isPaused,
    shards,
    maxReadRequestOperationCount,
    maxOutstandingReadRequests,
    maxReadRequestSize,
    maxWriteRequestOperationCount,
    maxWriteRequestSize,
    maxOutstandingWriteRequests,
    maxWriteBufferCount,
    maxWriteBufferSize,
    maxRetryDelay,
    readPollTimeout
  } = followerIndex;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.statusLabel",
    defaultMessage: "Status"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "status"
  }, isPaused ? isPollingStatus ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.checkingStatus",
    defaultMessage: "Checking status..."
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.pausedStatus",
    defaultMessage: "Paused"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.activeStatus",
    defaultMessage: "Active"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.remoteClusterLabel",
    defaultMessage: "Remote cluster"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "remoteCluster"
  }, remoteCluster))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.leaderIndexLabel",
    defaultMessage: "Leader index"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "leaderIndex"
  }, leaderIndex))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), !isPollingStatus && /*#__PURE__*/_react.default.createElement("section", {
    "aria-labelledby": "ccrFollowerIndexDetailSettingsTitle",
    "data-test-subj": "settingsSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: "ccrFollowerIndexDetailSettingsTitle"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.settingsTitle",
    defaultMessage: "Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), isPaused ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexDetailPanel.pausedFollowerCalloutTitle",
      defaultMessage: "A paused follower index does not have settings or shard statistics."
    })
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestOperationCountTitle",
    defaultMessage: "Max read request operation count"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxReadReqOpCount"
  }, maxReadRequestOperationCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingReadRequestsTitle",
    defaultMessage: "Max outstanding read requests"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxOutstandingReadReq"
  }, maxOutstandingReadRequests)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxReadRequestSizeTitle",
    defaultMessage: "Max read request size"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxReadReqSize"
  }, maxReadRequestSize))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestOperationCountTitle",
    defaultMessage: "Max write request operation count"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxWriteReqOpCount"
  }, maxWriteRequestOperationCount)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteRequestSizeTitle",
    defaultMessage: "Max write request size"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxWriteReqSize"
  }, maxWriteRequestSize))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxOutstandingWriteRequestsTitle",
    defaultMessage: "Max outstanding write requests"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxOutstandingWriteReq"
  }, maxOutstandingWriteRequests)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferCountTitle",
    defaultMessage: "Max write buffer count"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxWriteBufferCount"
  }, maxWriteBufferCount))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxWriteBufferSizeTitle",
    defaultMessage: "Max write buffer size"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxWriteBufferSize"
  }, maxWriteBufferSize)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.maxRetryDelayTitle",
    defaultMessage: "Max retry delay"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "maxRetryDelay"
  }, maxRetryDelay))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "settingsValues"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexForm.advancedSettings.readPollTimeoutTitle",
    defaultMessage: "Read poll timeout"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "readPollTimeout"
  }, readPollTimeout)))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("section", {
    "data-test-subj": "shardsStatsSection"
  }, shards && shards.map((shard, i) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: i
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.followerIndexDetailPanel.shardStatsTitle",
    defaultMessage: "Shard {id} stats",
    values: {
      id: shard.id
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    "data-test-subj": "shardsStats"
  }, JSON.stringify(shard, null, 2)))))));
};
const DetailPanel = ({
  followerIndexId,
  closeDetailPanel,
  followerIndex,
  apiStatus,
  getFollowerIndex
}) => {
  const [isInitialLoad, setInitialLoad] = (0, _react.useState)(true);
  const {
    isPolling,
    startPolling,
    stopPolling
  } = (0, _hooks.usePolling)();
  const shouldPollStatus = (0, _react.useCallback)(() => {
    const params = new URLSearchParams(window.location.search);
    return !isPolling && params.get('waitForActive') === 'true';
  }, [isPolling]);
  const clearWaitForActiveParam = (0, _react.useCallback)(() => {
    if (followerIndexId) {
      _routing.routing.navigate(`/follower_indices`, {
        name: encodeURIComponent(followerIndexId)
      });
    }
  }, [followerIndexId]);

  // Start polling once data is loaded
  (0, _react.useEffect)(() => {
    const shouldPoll = isInitialLoad && followerIndexId && followerIndex && !!(followerIndex !== null && followerIndex !== void 0 && followerIndex.isPaused) && shouldPollStatus();
    if (shouldPoll) {
      const onPoll = () => {
        getFollowerIndex(followerIndexId);
      };
      const onTimeout = () => {
        stopPolling();
        clearWaitForActiveParam();
      };
      startPolling(POLL_INTERVAL_MS, onPoll, POLL_TIMEOUT_MS, onTimeout);
      setInitialLoad(false);
    }
  }, [clearWaitForActiveParam, followerIndex, followerIndexId, getFollowerIndex, isInitialLoad, isPolling, shouldPollStatus, startPolling, stopPolling]);

  // Stop polling when status becomes active
  (0, _react.useEffect)(() => {
    const shouldStopPolling = isPolling && followerIndex && !followerIndex.isPaused;
    if (shouldStopPolling) {
      stopPolling();
      clearWaitForActiveParam();
    }
  }, [followerIndex, isPolling, stopPolling, clearWaitForActiveParam]);
  const renderContent = () => {
    if (apiStatus === _constants.API_STATUS.LOADING) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexDetailPanel.loadingLabel",
        defaultMessage: "Loading follower index\u2026"
      }))))));
    }
    if (!followerIndex) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "flexStart",
        alignItems: "center",
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "danger"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexDetailPanel.notFoundLabel",
        defaultMessage: "Follower index not found"
      }))))));
    }
    return /*#__PURE__*/_react.default.createElement(FollowerIndexDetails, {
      followerIndex: followerIndex,
      isPollingStatus: isPolling
    });
  };
  const renderFooter = () => {
    // Use ID instead of followerIndex, because followerIndex may not be loaded yet.
    const indexManagementUri = (0, _public.getIndexListUri)(`name:${followerIndexId}`);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: closeDetailPanel,
      "data-test-subj": "closeFlyoutButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexDetailPanel.closeButtonLabel",
      defaultMessage: "Close"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: _routing.routing._reactRouter.getUrlForApp('management', {
        path: `data/index_management${indexManagementUri}`
      }),
      "data-test-subj": "viewIndexManagementButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.followerIndexDetailPanel.viewIndexLink",
      defaultMessage: "View in Index Management"
    }))), followerIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_context_menu.ContextMenu, {
      iconSide: "left",
      iconType: "arrowUp",
      anchorPosition: "upRight",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexDetailPanel.manageButtonLabel",
        defaultMessage: "Manage"
      }),
      followerIndices: [followerIndex],
      testSubj: "manageButton",
      isPollingStatus: isPolling
    }))))));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "followerIndexDetail",
    onClose: closeDetailPanel,
    "aria-labelledby": "followerIndexDetailsFlyoutTitle",
    size: "m",
    maxWidth: 600
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    id: "followerIndexDetailsFlyoutTitle",
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, followerIndexId))), renderContent(), renderFooter());
};
exports.DetailPanel = DetailPanel;