"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.outdatedDocumentsSearchRead = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _helpers = require("../../../model/helpers");
var _progress = require("../../../model/progress");
var _extract_errors = require("../../../model/extract_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const outdatedDocumentsSearchRead = (state, res, context) => {
  if (Either.isLeft(res)) {
    (0, _helpers.throwBadResponse)(state, res);
  }
  let logs = state.logs;
  if (res.right.outdatedDocuments.length > 0) {
    // search returned outdated documents, so we process them
    const progress = (0, _progress.setProgressTotal)(state.progress, res.right.totalHits);
    return {
      ...state,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_TRANSFORM',
      outdatedDocuments: res.right.outdatedDocuments,
      lastHitSortValue: res.right.lastHitSortValue,
      logs: (0, _progress.logProgress)(state.logs, progress),
      progress
    };
  } else {
    // no more outdated documents , we need to move on
    if (state.corruptDocumentIds.length > 0 || state.transformErrors.length > 0) {
      if (!context.discardCorruptObjects) {
        const transformFailureReason = (0, _extract_errors.extractTransformFailuresReason)(context.migrationDocLinks.resolveMigrationFailures, state.corruptDocumentIds, state.transformErrors);
        return {
          ...state,
          controlState: 'FATAL',
          reason: transformFailureReason
        };
      }

      // at this point, users have configured kibana to discard corrupt objects
      // thus, we can ignore corrupt documents and transform errors and proceed with the migration
      logs = [...state.logs, {
        level: 'warning',
        message: (0, _extract_errors.extractDiscardedCorruptDocs)(state.corruptDocumentIds, state.transformErrors)
      }];
    }

    // If there are no more results we have transformed all outdated
    // documents and we didn't encounter any corrupt documents or transformation errors
    // and can proceed to the next step
    return {
      ...state,
      logs,
      controlState: 'OUTDATED_DOCUMENTS_SEARCH_CLOSE_PIT'
    };
  }
};
exports.outdatedDocumentsSearchRead = outdatedDocumentsSearchRead;