"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleSavedObjectImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Core internal implementation of {@link SimpleSavedObject}
 *
 * @internal Should use the {@link SimpleSavedObject} interface instead
 * @deprecated See https://github.com/elastic/kibana/issues/149098
 */
class SimpleSavedObjectImpl {
  constructor(client, {
    id,
    type,
    version,
    attributes,
    error,
    references,
    migrationVersion,
    coreMigrationVersion,
    typeMigrationVersion,
    managed,
    namespaces,
    updated_at: updatedAt,
    updated_by: updatedBy,
    created_at: createdAt,
    created_by: createdBy
  }) {
    (0, _defineProperty2.default)(this, "attributes", void 0);
    (0, _defineProperty2.default)(this, "_version", void 0);
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    /** @deprecated */
    (0, _defineProperty2.default)(this, "migrationVersion", void 0);
    (0, _defineProperty2.default)(this, "coreMigrationVersion", void 0);
    (0, _defineProperty2.default)(this, "typeMigrationVersion", void 0);
    (0, _defineProperty2.default)(this, "managed", void 0);
    (0, _defineProperty2.default)(this, "error", void 0);
    (0, _defineProperty2.default)(this, "references", void 0);
    (0, _defineProperty2.default)(this, "updatedAt", void 0);
    (0, _defineProperty2.default)(this, "updatedBy", void 0);
    (0, _defineProperty2.default)(this, "createdAt", void 0);
    (0, _defineProperty2.default)(this, "createdBy", void 0);
    (0, _defineProperty2.default)(this, "namespaces", void 0);
    this.client = client;
    this.id = id;
    this.type = type;
    this.attributes = attributes || {};
    this.references = references || [];
    this._version = version;
    this.migrationVersion = migrationVersion;
    this.coreMigrationVersion = coreMigrationVersion;
    this.typeMigrationVersion = typeMigrationVersion;
    this.managed = managed;
    this.namespaces = namespaces;
    this.updatedAt = updatedAt;
    this.createdAt = createdAt;
    this.createdBy = createdBy;
    this.updatedBy = updatedBy;
    if (error) {
      this.error = error;
    }
  }
  get(key) {
    return (0, _lodash.get)(this.attributes, key);
  }
  set(key, value) {
    return (0, _saferLodashSet.set)(this.attributes, key, value);
  }
  has(key) {
    return (0, _lodash.has)(this.attributes, key);
  }
  save() {
    if (this.id) {
      return this.client.update(this.type, this.id, this.attributes, {
        references: this.references
      }).then(sso => {
        this.updatedAt = sso.updatedAt;
        return sso;
      });
    } else {
      return this.client.create(this.type, this.attributes, {
        migrationVersion: this.migrationVersion,
        coreMigrationVersion: this.coreMigrationVersion,
        typeMigrationVersion: this.typeMigrationVersion,
        managed: this.managed,
        references: this.references
      }).then(sso => {
        this.updatedAt = sso.updatedAt;
        return sso;
      });
    }
  }
  delete() {
    return this.client.delete(this.type, this.id);
  }
}
exports.SimpleSavedObjectImpl = SimpleSavedObjectImpl;