"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Styles = void 0;
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const Styles = ({
  darkMode,
  stylesheetPaths
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, darkMode !== 'system' && /*#__PURE__*/_react.default.createElement(InlineStyles, {
    darkMode: darkMode
  }), stylesheetPaths.map(path => /*#__PURE__*/_react.default.createElement("link", {
    key: path,
    rel: "stylesheet",
    type: "text/css",
    href: path
  })));
};
exports.Styles = Styles;
const InlineStyles = ({
  darkMode
}) => {
  /* eslint-disable react/no-danger */
  return /*#__PURE__*/_react.default.createElement("style", {
    dangerouslySetInnerHTML: {
      __html: `

          html {
            background-color: ${darkMode ? '#141519' : '#F8FAFD'}
          }

          .kbnWelcomeText {
            color: ${darkMode ? '#98A2B3' : '#69707D'};
          }

          .kbnProgress {
            background-color: ${darkMode ? '#25262E' : '#F5F7FA'};
          }

          .kbnProgress:before {
            background-color: ${darkMode ? '#1BA9F5' : '#006DE4'};
          }

        `
    }
  });
  /* eslint-enable react/no-danger */
};