"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenderingService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _eui = require("@elastic/eui");
var _coreRenderingBrowser = require("@kbn/core-rendering-browser");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextRoot = require("@kbn/react-kibana-context-root");
var _app_containers = require("./app_containers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Renders all Core UI in a single React tree.
 *
 * @internalRemarks Currently this only renders Chrome UI. Notifications and
 * Overlays UI should be moved here as well.
 *
 * @internal
 */
class RenderingService {
  constructor() {
    (0, _defineProperty2.default)(this, "contextDeps", new _rxjs.BehaviorSubject(null));
  }
  /**
   * @internal
   */
  start(deps) {
    this.contextDeps.next(deps);
    const contract = {
      renderCore: this.renderCore.bind(this),
      addContext: this.addContext.bind(this)
    };
    return contract;
  }

  /**
   * @internal
   */
  renderCore(renderCoreDeps, targetDomElement) {
    const {
      chrome,
      application,
      overlays
    } = renderCoreDeps;
    const startServices = this.contextDeps.getValue();
    const chromeHeader = chrome.getHeaderComponent();
    const appComponent = application.getComponent();
    const bannerComponent = overlays.banners.getComponent();
    const body = document.querySelector('body');
    chrome.getBodyClasses$().pipe((0, _rxjs.startWith)([]), (0, _rxjs.pairwise)()).subscribe(([previousClasses, newClasses]) => {
      body.classList.remove(...previousClasses);
      body.classList.add(...newClasses);
    });
    _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRoot.KibanaRootContextProvider, (0, _extends2.default)({}, startServices, {
      globalStyles: true
    }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, chromeHeader, /*#__PURE__*/_react.default.createElement("div", {
      id: "globalBannerList"
    }, bannerComponent), /*#__PURE__*/_react.default.createElement(_app_containers.AppWrapper, {
      chromeVisible$: chrome.getIsVisible$()
    }, /*#__PURE__*/_react.default.createElement("div", {
      id: _coreRenderingBrowser.APP_FIXED_VIEWPORT_ID
    }), appComponent))), targetDomElement);
  }

  /**
   * @public
   */
  addContext(element) {
    const Component = () => {
      /**
       * The dependencies are captured using BehaviorSubject, because we assume that Kibana plugins' start
       * methods could be called before the CoreStart services are completely settled internally. If this
       * assumption is wrong, the available dependencies are given as the initial value to `useObservable`, and
       * there is no unnecessary re-render.
       */
      const deps = (0, _useObservable.default)(this.contextDeps, this.contextDeps.getValue());
      if (!deps) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "s"
        });
      }
      return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, {
        analytics: deps.analytics,
        executionContext: deps.executionContext,
        i18n: deps.i18n,
        theme: deps.theme,
        userProfile: deps.userProfile
      }, element);
    };
    return /*#__PURE__*/_react.default.createElement(Component, null);
  }
}
exports.RenderingService = RenderingService;