"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.rollingStrategyConfigSchema = exports.createRollingStrategy = void 0;
var _configSchema = require("@kbn/config-schema");
var _numeric = require("./numeric");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultStrategy = {
  type: 'numeric',
  pattern: '-%i',
  max: 7
};
const rollingStrategyConfigSchema = exports.rollingStrategyConfigSchema = _configSchema.schema.oneOf([_numeric.numericRollingStrategyConfigSchema], {
  defaultValue: defaultStrategy
});
const createRollingStrategy = (config, context) => {
  return new _numeric.NumericRollingStrategy(config, context);
};
exports.createRollingStrategy = createRollingStrategy;