"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatNumber = formatNumber;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function formatNumber(num, type) {
  let format;
  let postfix = '';
  switch (type) {
    case 'byte':
      format = '0.00 b';
      break;
    case 'time':
      format = '0.00';
      postfix = ' ms';
      break;
    case 'integer':
      format = '0';
      break;
    case 'float':
    default:
      format = '0.00';
  }
  return (0, _numeral.default)(num).format(format) + postfix;
}