"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _status_badge = require("./status_badge");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ServerStatus = ({
  name,
  serverState
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "spaceBetween",
  style: {
    flexGrow: 0
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", {
  "data-test-subj": "serverStatusTitle"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "core.statusPage.serverStatus.statusTitle",
  defaultMessage: "Kibana status is {kibanaStatus}",
  values: {
    kibanaStatus: /*#__PURE__*/_react.default.createElement(_status_badge.StatusBadge, {
      status: serverState,
      "data-test-subj": "serverStatusTitleBadge"
    })
  }
})))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, name))));
exports.ServerStatus = ServerStatus;