"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureFlagsConfig = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The definition of the validation config schema
 * @internal
 */
const configSchema = _configSchema.schema.object({
  overrides: _configSchema.schema.maybe(_configSchema.schema.recordOf(_configSchema.schema.string(), _configSchema.schema.any()))
});

/**
 * Type definition of the Feature Flags configuration
 * @internal
 */

/**
 * Config descriptor for the feature flags service
 * @internal
 */
const featureFlagsConfig = exports.featureFlagsConfig = {
  /**
   * All config is prefixed by `feature_flags`
   */
  path: 'feature_flags',
  /**
   * The definition of the validation config schema
   */
  schema: configSchema
};