"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeDefaultControlManager = exports.defaultControlDefaultValues = exports.defaultControlComparators = void 0;
var _state_manager = require("@kbn/presentation-publishing/state_manager");
var _rxjs = require("rxjs");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultControlComparators = exports.defaultControlComparators = {
  grow: 'referenceEquality',
  width: 'referenceEquality'
};
const defaultControlDefaultValues = exports.defaultControlDefaultValues = {
  grow: _common.DEFAULT_CONTROL_GROW,
  width: _common.DEFAULT_CONTROL_WIDTH
};
const initializeDefaultControlManager = state => {
  const dataLoading$ = new _rxjs.BehaviorSubject(false);
  const blockingError$ = new _rxjs.BehaviorSubject(undefined);
  const stateManager = (0, _state_manager.initializeStateManager)(state, defaultControlDefaultValues);
  return {
    ...stateManager,
    api: {
      ...stateManager.api,
      dataLoading$,
      blockingError$,
      setBlockingError: error => blockingError$.next(error),
      setDataLoading: loading => dataLoading$.next(loading)
    }
  };
};
exports.initializeDefaultControlManager = initializeDefaultControlManager;