"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openEditControlGroupFlyout = void 0;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _control_group_editor = require("./components/control_group_editor");
var _kibana_services = require("../services/kibana_services");
var _confirm_delete_control = require("../common/confirm_delete_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const openEditControlGroupFlyout = (controlGroupApi, stateManager) => {
  const lastSavedState = stateManager.getLatestState();
  const closeOverlay = overlayRef => {
    if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationContainers.tracksOverlays)(controlGroupApi.parentApi)) {
      controlGroupApi.parentApi.clearOverlays();
    }
    overlayRef.close();
  };
  const onDeleteAll = ref => {
    (0, _confirm_delete_control.confirmDeleteAllControls)().then(confirmed => {
      if (confirmed) Object.keys(controlGroupApi.children$.getValue()).forEach(childId => {
        controlGroupApi.removePanel(childId);
      });
      closeOverlay(ref);
    });
  };
  const overlay = _kibana_services.coreServices.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_control_group_editor.ControlGroupEditor, {
    api: controlGroupApi,
    stateManager: stateManager,
    onSave: () => {
      closeOverlay(overlay);
    },
    onDeleteAll: () => onDeleteAll(overlay),
    onCancel: () => {
      stateManager.reinitializeState(lastSavedState);
      closeOverlay(overlay);
    }
  }), _kibana_services.coreServices), {
    'aria-label': _i18n.i18n.translate('controls.controlGroup.manageControl', {
      defaultMessage: 'Edit control settings'
    }),
    size: 'm',
    maxWidth: 500,
    paddingSize: 'm',
    outsideClickCloses: false,
    onClose: () => closeOverlay(overlay)
  });
  if ((0, _presentationPublishing.apiHasParentApi)(controlGroupApi) && (0, _presentationContainers.tracksOverlays)(controlGroupApi.parentApi)) {
    controlGroupApi.parentApi.openOverlay(overlay);
  }
};
exports.openEditControlGroupFlyout = openEditControlGroupFlyout;