"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VulnerabilityOverviewTab = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react2 = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _fp = require("lodash/fp");
var _get_vendor_name = require("@kbn/cloud-security-posture/src/utils/get_vendor_name");
var _findings_flyout = require("../../configurations/findings_flyout/findings_flyout");
var _nvd_logo_svg = require("../../../assets/icons/nvd_logo_svg");
var _get_vector_score_list = require("../utils/get_vector_score_list");
var _test_subjects = require("../test_subjects");
var _redhat_logo = _interopRequireDefault(require("../../../assets/icons/redhat_logo.svg"));
var _vulnerability_detection_rule_counter = require("./vulnerability_detection_rule_counter");
var _copy_button = require("../../../components/copy_button");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const cvssVendors = {
  nvd: 'NVD',
  redhat: 'Red Hat',
  ghsa: 'GHSA'
};
const vendorIcons = {
  redhat: _redhat_logo.default,
  ghsa: 'logoGithub'
};
const EMPTY_VALUE = '-';
const CVSScore = ({
  vectorBaseScore,
  vendor
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const vendorName = cvssVendors[vendor];
  const vectorScores = (0, _get_vector_score_list.getVectorScoreList)(vectorBaseScore);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        border: 1px solid ${euiTheme.border.color};
        border-radius: 6px;
        padding: ${euiTheme.size.m};
      `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
          width: 116px;
          font-weight: 600;
          display: flex;
          flex-direction: row;
          align-items: center;
        `
  }, /*#__PURE__*/_react2.default.createElement("span", {
    css: (0, _react.css)`
            margin-right: 30px;
          `
  }, vendor === 'nvd' ? (0, _nvd_logo_svg.NvdLogo)() : /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    type: vendorIcons[vendor],
    size: "xl"
  })), /*#__PURE__*/_react2.default.createElement("span", null, vendorName)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, vectorScores.length > 0 && vectorScores.map((vectorScore, i) => /*#__PURE__*/_react2.default.createElement(VectorScore, {
    key: `${vectorScore}-${i}`,
    vectorScore: vectorScore
  }))));
};
const VectorScore = ({
  vectorScore
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    score,
    vector,
    version
  } = vectorScore;
  return /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
          background: ${euiTheme.colors.backgroundLightText};
          padding: ${euiTheme.size.xs} ${euiTheme.size.s};
          border-radius: 6px;
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: (0, _react.css)`
              font-size: ${euiTheme.size.m};
              color: ${euiTheme.colors.textParagraph};
            `
  }, vector, ' ')), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, score && /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    score: score,
    version: version
  }))));
};
const VulnerabilityOverviewTiles = ({
  vulnerabilityRecord
}) => {
  var _vulnerability$score, _vulnerability$score2, _vulnerability$data_s, _vulnerability$data_s2;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    vulnerability
  } = vulnerabilityRecord;
  const tileStyle = (0, _react.css)`
    padding: ${euiTheme.size.m};
    background: ${euiTheme.colors.backgroundLightText};
    border-radius: 6px;
    height: 74px;
  `;
  const tileTitleTextStyle = (0, _react.css)`
    line-height: 20px;
    margin-bottom: 6px;
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": _test_subjects.OVERVIEW_TAB_VULNERABILITY_FLYOUT
  }, !!(vulnerability !== null && vulnerability !== void 0 && (_vulnerability$score = vulnerability.score) !== null && _vulnerability$score !== void 0 && _vulnerability$score.base) && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: tileStyle
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: tileTitleTextStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.cvsScore",
    defaultMessage: "CVSS"
  })), /*#__PURE__*/_react2.default.createElement("div", null, /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    version: (_vulnerability$score2 = vulnerability.score) === null || _vulnerability$score2 === void 0 ? void 0 : _vulnerability$score2.version,
    score: vulnerability.score.base
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: tileStyle,
    "data-test-subj": _test_subjects.DATA_SOURCE_VULNERABILITY_FLYOUT
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    css: tileTitleTextStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.dataSource",
    defaultMessage: "Data Source"
  })), (_vulnerability$data_s = vulnerability.data_source) !== null && _vulnerability$data_s !== void 0 && _vulnerability$data_s.URL ? /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
    href: (_vulnerability$data_s2 = vulnerability.data_source) === null || _vulnerability$data_s2 === void 0 ? void 0 : _vulnerability$data_s2.URL,
    target: "_blank"
  }, vulnerability.data_source.ID) : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, EMPTY_VALUE)));
};
const VulnerabilityOverviewTab = ({
  vulnerabilityRecord
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    vulnerability
  } = vulnerabilityRecord;
  _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.COUNT, _ui_metrics.VULNERABILITIES_FLYOUT_VISITS);
  const emptyFixesMessageState = _i18n.i18n.translate('xpack.csp.vulnerabilities.vulnerabilityOverviewTab.emptyFixesMessage', {
    defaultMessage: 'No available fixes yet.'
  });
  const renderFixedBySection = () => {
    var _vulnerabilityRecord$;
    const renderFinding = (item, i, field, object) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      direction: "row",
      justifyContent: "flexStart",
      alignItems: "center"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      css: (0, _react.css)`
              white-space: nowrap;
              overflow: hidden;
              text-overflow: ellipsis;
            `
    }, item)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_copy_button.CopyButton, {
      copyText: item
    })));
    const renderPackageField = field => {
      const value = (0, _fp.get)(field, vulnerabilityRecord);
      if (!value) {
        return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
          size: "xs"
        }, EMPTY_VALUE);
      }
      return Array.isArray(value) ? /*#__PURE__*/_react2.default.createElement(_cloudSecurityPosture.MultiValueCellPopover, {
        items: value,
        field: `package.${field}`,
        object: vulnerabilityRecord,
        renderItem: renderFinding
      }) : value;
    };
    if (!(vulnerabilityRecord !== null && vulnerabilityRecord !== void 0 && (_vulnerabilityRecord$ = vulnerabilityRecord.package) !== null && _vulnerabilityRecord$ !== void 0 && _vulnerabilityRecord$.fixed_version)) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, emptyFixesMessageState);
    }
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "flexStart",
      direction: "column"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      justifyContent: "flexStart",
      alignItems: "center"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _react.css)`
                  font-weight: ${euiTheme.font.weight.bold};
                `
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.packageTitle",
      defaultMessage: "Package"
    }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, renderPackageField('package.name')))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      justifyContent: "flexStart",
      alignItems: "center"
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "xs",
      css: (0, _react.css)`
                  font-weight: ${euiTheme.font.weight.bold};
                `
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      css: (0, _react.css)`
                    font-weight: ${euiTheme.font.weight.medium};
                  `,
      id: "xpack.csp.vulnerabilities.vulnerabilitiesFindingFlyout.flyoutDescriptionList.versionTitle",
      defaultMessage: "Version"
    }), ":")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, renderPackageField('package.fixed_version')))));
  };
  const cvssScores = vulnerability !== null && vulnerability !== void 0 && vulnerability.cvss ? Object.entries(vulnerability.cvss).map(([vendor, vectorScoreBase]) => {
    if (cvssVendors[vendor]) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
        key: `${vendor}`
      }, /*#__PURE__*/_react2.default.createElement(CVSScore, {
        vectorBaseScore: vectorScoreBase,
        vendor: vendor
      }));
    }
  }) : [];
  const [showAllReferences, setShowAllReferences] = (0, _react2.useState)(false);
  const renderCVE = () => {
    if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.id) || vulnerability.id.length === 0) {
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, null, EMPTY_VALUE);
    }
    const sortReferencesByName = () => {
      // Handle case where either reference or id is not an array
      const ids = Array.isArray(vulnerability.id) ? vulnerability.id : [vulnerability.id];
      const references = Array.isArray(vulnerability.reference) ? vulnerability.reference : [vulnerability.reference];
      return ids.map(id => {
        const referenceLink = (0, _cloudSecurityPosture.findReferenceLink)(references, id);
        return {
          id,
          link: referenceLink !== null && referenceLink !== void 0 ? referenceLink : ''
        };
      });
    };
    const sortedReferences = sortReferencesByName();
    const MAX_VISIBLE_ITEMS = 4;
    const hasMoreItems = sortedReferences.length > MAX_VISIBLE_ITEMS;
    const visibleReferences = showAllReferences ? sortedReferences : sortedReferences.slice(0, MAX_VISIBLE_ITEMS);
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      alignItems: "center",
      css: (0, _react.css)`
          max-height: 200px;
          overflow-y: auto;
          flex-wrap: wrap;
        `
    }, visibleReferences.map(({
      id,
      link
    }, index) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      key: `${id}-${index}`,
      grow: false,
      style: {
        flexShrink: 0
      }
    }, link ? /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "m",
      color: "primary",
      style: {
        display: 'flex'
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiLink, {
      "data-test-subj": (0, _test_subjects.getVulnerabilityLinkTestId)(id),
      href: link,
      target: "_blank",
      css: (0, _react.css)`
                    display: inline-flex;
                    align-items: center;
                  `
    }, id), index !== visibleReferences.length - 1 && ',') : /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_TAB_ID,
      size: "m"
    }, index === visibleReferences.length - 1 ? id : `${id},`))), !showAllReferences && hasMoreItems && /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s"
    }, "...")), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_TAB_ID_MORE_BTN,
      color: "primary",
      size: "xs",
      onClick: () => setShowAllReferences(true)
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.showMore",
      defaultMessage: "Show more"
    })))), showAllReferences && /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_TAB_ID_LESS_BTN,
      color: "primary",
      size: "xs",
      onClick: () => setShowAllReferences(false)
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.showLess",
      defaultMessage: "Show less"
    }))));
  };
  const horizontalStyle = (0, _react.css)`
    margin-block: 0px;
  `;
  const flyoutSubheadingStyle = (0, _react.css)`
    font-size: ${euiTheme.size.m};
    line-height: 24px;
    margin-bottom: ${euiTheme.size.s};
    font-weight: 700;
  `;
  const date = vulnerability !== null && vulnerability !== void 0 && vulnerability.published_date ? (0, _moment.default)(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.published_date).format('LL').toString() : null;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement(VulnerabilityOverviewTiles, {
    vulnerabilityRecord: vulnerabilityRecord
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.cve",
    defaultMessage: "CVE"
  })), renderCVE()), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.VULNERABILITY_OVERVIEW_PUBLISHED_DATE
  }, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.published",
    defaultMessage: "Published"
  })), vulnerability !== null && vulnerability !== void 0 && vulnerability.published_date ? /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTile.publishedDateText",
    defaultMessage: "{date}",
    values: {
      date
    }
  }) : EMPTY_VALUE), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.alertsTitle",
    defaultMessage: "Alerts"
  })), vulnerabilityRecord.vulnerability.id ? /*#__PURE__*/_react2.default.createElement(_vulnerability_detection_rule_counter.VulnerabilityDetectionRuleCounter, {
    vulnerabilityRecord: vulnerabilityRecord
  }) : EMPTY_VALUE), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.vendorTitle",
    defaultMessage: "Vendor"
  })), (0, _get_vendor_name.getVendorName)(vulnerabilityRecord) || EMPTY_VALUE), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.descriptionTitle",
    defaultMessage: "Description"
  })), /*#__PURE__*/_react2.default.createElement(_findings_flyout.CspFlyoutMarkdown, null, (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.description) || EMPTY_VALUE)), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.fixes",
    defaultMessage: "Fixed by"
  })), renderFixedBySection()), /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
    css: horizontalStyle
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.VULNERABILITY_SCORES_FLYOUT
  }, /*#__PURE__*/_react2.default.createElement("h4", {
    css: flyoutSubheadingStyle
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.vulnerabilities.vulnerabilityOverviewTab.vulnerabilityScores",
    defaultMessage: "Vulnerability Scores"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    css: (0, _react.css)`
              margin-top: ${euiTheme.size.s};
            `
  }, !!(cvssScores !== null && cvssScores !== void 0 && cvssScores.length) ? cvssScores : EMPTY_VALUE)));
};
exports.VulnerabilityOverviewTab = VulnerabilityOverviewTab;