"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFindCspBenchmarkRule = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../../common/hooks/use_kibana");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFindCspBenchmarkRule = ({
  search,
  page,
  perPage,
  section,
  ruleNumber,
  sortField,
  sortOrder
}, benchmarkId, benchmarkVersion) => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  return (0, _reactQuery.useQuery)([_constants.CSP_BENCHMARK_RULE_SAVED_OBJECT_TYPE, {
    section,
    search,
    page,
    perPage,
    benchmarkId,
    benchmarkVersion,
    ruleNumber,
    sortField,
    sortOrder
  }], () => {
    return http.get(_constants.FIND_CSP_BENCHMARK_RULE_ROUTE_PATH, {
      query: {
        benchmarkId,
        page,
        perPage,
        search,
        section,
        benchmarkVersion,
        ruleNumber,
        sortField,
        sortOrder
      },
      version: '3'
    });
  });
};
exports.useFindCspBenchmarkRule = useFindCspBenchmarkRule;