"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setGetCloudSolutionDataRoute = void 0;
var _constants = require("./constants");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setGetCloudSolutionDataRoute = ({
  router
}) => {
  router.versioned.get({
    path: `/internal/cloud/solution`,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to the saved objects client'
      }
    },
    access: 'internal',
    summary: 'Get cloud data for solutions'
  }).addVersion({
    version: '1',
    validate: {
      request: {}
    }
  }, async (context, request, response) => {
    const coreContext = await context.core;
    const savedObjectsClient = coreContext.savedObjects.getClient({
      includedHiddenTypes: [_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE]
    });
    try {
      var _cloudDataSo$attribut;
      const cloudDataSo = await savedObjectsClient.get(_saved_objects.CLOUD_DATA_SAVED_OBJECT_TYPE, _constants.CLOUD_DATA_SAVED_OBJECT_ID);
      return response.ok({
        body: (_cloudDataSo$attribut = cloudDataSo === null || cloudDataSo === void 0 ? void 0 : cloudDataSo.attributes) !== null && _cloudDataSo$attribut !== void 0 ? _cloudDataSo$attribut : null
      });
    } catch (error) {
      return response.customError(error);
    }
  });
};
exports.setGetCloudSolutionDataRoute = setGetCloudSolutionDataRoute;