"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CasesUiPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _history = require("history");
var _kibana = require("./common/lib/kibana");
var _constants = require("../common/constants");
var _translations = require("./common/translations");
var _use_cases_add_to_existing_case_modal = require("./components/all_cases/selector_modal/use_cases_add_to_existing_case_modal");
var _use_cases_add_to_new_case_flyout = require("./components/create/flyout/use_cases_add_to_new_case_flyout");
var _use_is_add_to_case_open = require("./components/cases_context/state/use_is_add_to_case_open");
var _api = require("./client/api");
var _can_use_cases = require("./client/helpers/can_use_cases");
var _get_rule_id_from_event = require("./client/helpers/get_rule_id_from_event");
var _get_all_cases_selector_modal = require("./client/ui/get_all_cases_selector_modal");
var _get_cases = require("./client/ui/get_cases");
var _get_cases_context = require("./client/ui/get_cases_context");
var _get_recent_cases = require("./client/ui/get_recent_cases");
var _group_alerts_by_rule = require("./client/helpers/group_alerts_by_rule");
var _capabilities = require("./client/helpers/capabilities");
var _external_reference_registry = require("./client/attachment_framework/external_reference_registry");
var _persistable_state_registry = require("./client/attachment_framework/persistable_state_registry");
var _files = require("./files");
var _internal_attachments = require("./internal_attachments");
var _actions = require("./components/visualizations/actions");
var _system_actions = require("./components/system_actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * @public
 * A plugin for retrieving Cases UI components
 */
class CasesUiPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "storage", new _public.Storage(localStorage));
    (0, _defineProperty2.default)(this, "externalReferenceAttachmentTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "persistableStateAttachmentTypeRegistry", void 0);
    this.initializerContext = initializerContext;
    this.kibanaVersion = initializerContext.env.packageInfo.version;
    this.externalReferenceAttachmentTypeRegistry = new _external_reference_registry.ExternalReferenceAttachmentTypeRegistry();
    this.persistableStateAttachmentTypeRegistry = new _persistable_state_registry.PersistableStateAttachmentTypeRegistry();
  }
  setup(core, plugins) {
    const kibanaVersion = this.kibanaVersion;
    const storage = this.storage;
    const externalReferenceAttachmentTypeRegistry = this.externalReferenceAttachmentTypeRegistry;
    const persistableStateAttachmentTypeRegistry = this.persistableStateAttachmentTypeRegistry;
    (0, _internal_attachments.registerInternalAttachments)(externalReferenceAttachmentTypeRegistry, persistableStateAttachmentTypeRegistry);
    const config = this.initializerContext.config.get();
    (0, _files.registerCaseFileKinds)(config.files, plugins.files);
    if (plugins.home) {
      plugins.home.featureCatalogue.register({
        id: _constants.APP_ID,
        title: _translations.APP_TITLE,
        description: _translations.APP_DESC,
        icon: 'casesApp',
        path: _constants.APP_PATH,
        showOnHomePage: false,
        category: 'admin'
      });
    }
    if (config.stack.enabled) {
      plugins.management.sections.section.insightsAndAlerting.registerApp({
        id: _constants.APP_ID,
        title: _translations.APP_TITLE,
        order: 1,
        async mount(params) {
          const [coreStart, pluginsStart] = await core.getStartServices();
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          return renderApp({
            mountParams: params,
            coreStart,
            pluginsStart,
            storage,
            kibanaVersion,
            externalReferenceAttachmentTypeRegistry,
            persistableStateAttachmentTypeRegistry
          });
        }
      });
    }
    (0, _system_actions.registerSystemActions)(plugins.triggersActionsUi);
    return {
      attachmentFramework: {
        registerExternalReference: externalReferenceAttachmentType => {
          this.externalReferenceAttachmentTypeRegistry.register(externalReferenceAttachmentType);
        },
        registerPersistableState: persistableStateAttachmentType => {
          this.persistableStateAttachmentTypeRegistry.register(persistableStateAttachmentType);
        }
      }
    };
  }
  start(core, plugins) {
    const config = this.initializerContext.config.get();
    _kibana.KibanaServices.init({
      ...core,
      ...plugins,
      kibanaVersion: this.kibanaVersion,
      config
    });

    /**
     * getCasesContextLazy returns a new component each time is being called. To avoid re-renders
     * we get the component on start and provide the same component to all consumers.
     */
    const getCasesContext = (0, _get_cases_context.getCasesContextLazy)({
      externalReferenceAttachmentTypeRegistry: this.externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry,
      getFilesClient: plugins.files.filesClientFactory.asScoped
    });
    (0, _actions.registerActions)({
      externalReferenceAttachmentTypeRegistry: this.externalReferenceAttachmentTypeRegistry,
      persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry,
      getFilesClient: plugins.files.filesClientFactory.asScoped
    }, {
      core,
      plugins,
      history: (0, _history.createBrowserHistory)(),
      storage: this.storage
    });
    return {
      api: (0, _api.createClientAPI)({
        http: core.http
      }),
      ui: {
        getCases: props => (0, _get_cases.getCasesLazy)({
          ...props,
          externalReferenceAttachmentTypeRegistry: this.externalReferenceAttachmentTypeRegistry,
          persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry,
          getFilesClient: plugins.files.filesClientFactory.asScoped
        }),
        getCasesContext,
        getRecentCases: props => (0, _get_recent_cases.getRecentCasesLazy)({
          ...props,
          externalReferenceAttachmentTypeRegistry: this.externalReferenceAttachmentTypeRegistry,
          persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry,
          getFilesClient: plugins.files.filesClientFactory.asScoped
        }),
        // @deprecated Please use the hook useCasesAddToExistingCaseModal
        getAllCasesSelectorModal: props => (0, _get_all_cases_selector_modal.getAllCasesSelectorModalLazy)({
          ...props,
          externalReferenceAttachmentTypeRegistry: this.externalReferenceAttachmentTypeRegistry,
          persistableStateAttachmentTypeRegistry: this.persistableStateAttachmentTypeRegistry,
          getFilesClient: plugins.files.filesClientFactory.asScoped
        })
      },
      hooks: {
        useCasesAddToNewCaseFlyout: _use_cases_add_to_new_case_flyout.useCasesAddToNewCaseFlyout,
        useCasesAddToExistingCaseModal: _use_cases_add_to_existing_case_modal.useCasesAddToExistingCaseModal,
        useIsAddToCaseOpen: _use_is_add_to_case_open.useIsAddToCaseOpen
      },
      helpers: {
        canUseCases: (0, _can_use_cases.canUseCases)(core.application.capabilities),
        getUICapabilities: _capabilities.getUICapabilities,
        getRuleIdFromEvent: _get_rule_id_from_event.getRuleIdFromEvent,
        groupAlertsByRule: _group_alerts_by_rule.groupAlertsByRule
      }
    };
  }
  stop() {}
}
exports.CasesUiPlugin = CasesUiPlugin;