"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUserActionAriaLabel = void 0;
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getUserActionAriaLabel = type => {
  const actionsMap = {
    assignees: i18n.ASSIGNEES,
    comment: i18n.COMMENT,
    connector: i18n.CONNECTORS,
    description: i18n.DESCRIPTION,
    pushed: i18n.PUSHED_NEW_INCIDENT,
    tags: i18n.TAGS,
    title: i18n.TITLE,
    status: i18n.STATUS,
    settings: i18n.SETTING,
    severity: i18n.SEVERITY,
    create_case: i18n.CASE_INITIATED,
    delete_case: i18n.CASE_DELETED,
    category: i18n.CATEGORY,
    customFields: i18n.CUSTOM_FIELDS
  };
  switch (type) {
    case 'create_case':
    case 'delete_case':
    case 'pushed':
      return actionsMap[type];
    default:
      return i18n.USER_ACTION_EDITED(actionsMap[type]);
  }
};
exports.getUserActionAriaLabel = getUserActionAriaLabel;